/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl;

import org.limewire.concurrent.ThreadExecutor;
import org.limewire.friend.api.FriendConnection;
import org.limewire.friend.api.FriendConnectionConfiguration;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.friend.api.FriendException;
import org.limewire.friend.api.Network;
import org.limewire.listener.EventListener;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.DebugRunnable;
import org.limewire.xmpp.client.impl.XMPPConnectionFactoryImpl;

class ReconnectionManager
implements EventListener<FriendConnectionEvent> {
    private static final int MAX_RECONNECTION_ATTEMPTS = 10;
    private static final Log LOG = LogFactory.getLog(ReconnectionManager.class);
    private final XMPPConnectionFactoryImpl serviceImpl;
    private volatile boolean connected;

    ReconnectionManager(XMPPConnectionFactoryImpl serviceImpl) {
        this.serviceImpl = serviceImpl;
    }

    @Override
    public void handleEvent(FriendConnectionEvent event) {
        if (((FriendConnection)event.getSource()).getConfiguration().getType() == Network.Type.XMPP) {
            if (event.getType() == FriendConnectionEvent.Type.CONNECTED) {
                this.connected = true;
            } else if (event.getType() == FriendConnectionEvent.Type.DISCONNECTED) {
                if (event.getException() != null && this.connected) {
                    FriendConnection connection = (FriendConnection)event.getSource();
                    final FriendConnectionConfiguration configuration = connection.getConfiguration();
                    Thread t = ThreadExecutor.newManagedThread(new DebugRunnable(new Runnable(){

                        @Override
                        public void run() {
                            long sleepTime = 10000L;
                            FriendConnection newConnection = null;
                            for (int i = 0; i < 10 && newConnection == null; ++i) {
                                try {
                                    LOG.debugf("attempting to reconnect to {0} ..." + configuration.getServiceName(), new Object[0]);
                                    newConnection = ReconnectionManager.this.serviceImpl.loginImpl(configuration, true);
                                }
                                catch (FriendException e) {
                                    // empty catch block
                                }
                                try {
                                    Thread.sleep(sleepTime);
                                    continue;
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                            }
                            LOG.debugf("giving up trying to connect to {0}" + configuration.getServiceName(), new Object[0]);
                        }
                    }), "xmpp-reconnection-manager");
                    t.start();
                }
                this.connected = false;
            }
        }
    }
}

