/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;

public class VersionUtils {
    private VersionUtils() {
    }

    public static boolean isJava15OrAbove() {
        return VersionUtils.isJavaVersionOrAbove("1.5");
    }

    public static boolean isJava16OrAbove() {
        return VersionUtils.isJavaVersionOrAbove("1.6");
    }

    public static boolean isJavaVersionAbove(String version) {
        try {
            Version java = new Version(VersionUtils.getJavaVersion());
            Version given = new Version(version);
            return java.compareTo(given) >= 1;
        }
        catch (VersionFormatException vfe) {
            return false;
        }
    }

    public static boolean isJavaVersionOrAbove(String version) {
        try {
            Version java = new Version(VersionUtils.getJavaVersion());
            Version given = new Version(version);
            return java.compareTo(given) >= 0;
        }
        catch (VersionFormatException vfe) {
            return false;
        }
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }
}

