/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.wizard;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXPanel;
import org.limewire.ui.swing.activation.LicenseKeyTextField;
import org.limewire.ui.swing.components.decorators.ButtonDecorator;
import org.limewire.ui.swing.components.decorators.TextFieldDecorator;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.painter.GenericBarPainter;
import org.limewire.ui.swing.painter.GreenButtonBackgroundPainter;
import org.limewire.ui.swing.painter.LightButtonBackgroundPainter;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.PainterUtils;

public class SetupComponentDecorator {
    private final ButtonDecorator plainButtonDecorator;
    private final TextFieldDecorator textFieldDecorator;
    @Resource
    private Font headingFont;
    @Resource
    private Color headingFontColor;
    @Resource
    private Font normalFont;
    @Resource
    private Color normalFontColor;
    @Resource
    private Font subHeadingFont;
    @Resource
    private Color subHeadingFontColor;
    @Resource
    private Font linkFont;
    @Resource
    private Color greenButtonForeground;
    @Resource
    private Font greenButtonFont;
    @Resource
    private Font backButtonFont;
    @Resource
    private Icon largeBox;
    @Resource
    private Icon largeBoxChecked;
    @Resource
    private Icon largeRadio;
    @Resource
    private Icon largeRadioChecked;
    @Resource
    private Color headerGradientTop;
    @Resource
    private Color headerGradientBottom;
    @Resource
    private Color headerTopBorder1 = PainterUtils.TRASPARENT;
    @Resource
    private Color headerTopBorder2 = PainterUtils.TRASPARENT;
    @Resource
    private Color headerBottomBorder1 = PainterUtils.TRASPARENT;
    @Resource
    private Color headerBottomBorder2 = PainterUtils.TRASPARENT;
    private final GenericBarPainter<JXPanel> pooledBarPainter;

    @Inject
    SetupComponentDecorator(ButtonDecorator plainButtonDecorator, TextFieldDecorator textFieldDecorator) {
        GuiUtils.assignResources(this);
        this.plainButtonDecorator = plainButtonDecorator;
        this.textFieldDecorator = textFieldDecorator;
        this.pooledBarPainter = new GenericBarPainter(new GradientPaint(0.0f, 0.0f, this.headerGradientTop, 0.0f, 1.0f, this.headerGradientBottom, false), this.headerTopBorder1, this.headerTopBorder2, this.headerBottomBorder1, this.headerBottomBorder2);
    }

    public void decorateLargeCheckBox(JCheckBox box) {
        box.setIcon(this.largeBox);
        box.setSelectedIcon(this.largeBoxChecked);
        box.setOpaque(false);
        box.setFocusPainted(false);
    }

    public void decorateLicenseKeyField(LicenseKeyTextField textField) {
        this.textFieldDecorator.decorateLicenseField(textField, BorderPainter.AccentType.BUBBLE);
    }

    public void decorateLargeRadioButton(JRadioButton box) {
        box.setIcon(this.largeRadio);
        box.setSelectedIcon(this.largeRadioChecked);
        box.setOpaque(false);
        box.setFocusPainted(false);
    }

    public void decorateGreenButton(JXButton button) {
        button.setBackgroundPainter(new GreenButtonBackgroundPainter());
        button.setForeground(this.greenButtonForeground);
        button.setFont(this.greenButtonFont);
        button.setOpaque(false);
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setBorder(BorderFactory.createEmptyBorder(0, 10, 3, 10));
        button.setMaximumSize(new Dimension(Integer.MAX_VALUE, 32));
        button.setMinimumSize(new Dimension(105, 32));
    }

    public void decorateGreyButton(JXButton button) {
        button.setBackgroundPainter(new LightButtonBackgroundPainter());
        button.setOpaque(false);
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setBorder(BorderFactory.createEmptyBorder(3, 15, 4, 15));
    }

    public void decorateBackButton(JComponent button) {
        button.setFont(this.backButtonFont);
        button.setBorder(BorderFactory.createEmptyBorder(0, 10, 3, 10));
    }

    public void decorateLink(JComponent link) {
        link.setOpaque(false);
        link.setFont(this.linkFont);
    }

    public void decoratePlainButton(JXButton button) {
        this.plainButtonDecorator.decorateDarkFullButton(button, BorderPainter.AccentType.NONE);
    }

    public void decorateSetupHeader(JXPanel header) {
        header.setBackgroundPainter(this.pooledBarPainter);
        header.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)header.getMaximumSize().getHeight()));
    }

    public void decorateHeadingText(JComponent component) {
        component.setFont(this.headingFont);
        component.setForeground(this.headingFontColor);
        component.setOpaque(false);
    }

    public void decorateNormalText(JComponent component) {
        component.setFont(this.normalFont);
        component.setForeground(this.normalFontColor);
        component.setOpaque(false);
    }

    public void decorateSubHeading(JComponent component) {
        component.setFont(this.subHeadingFont);
        component.setForeground(this.subHeadingFontColor);
        component.setOpaque(false);
    }
}

