/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.util.Properties;

public class OSXFolderDialog
extends FileDialog {
    private boolean modeCheckingEnabled = false;
    private static float mrjVersion = -1.0f;

    public OSXFolderDialog(Frame parent) {
        this(parent, "");
        mrjVersion = OSXFolderDialog.loadMRJVersion();
    }

    public OSXFolderDialog(Frame parent, String title) {
        super(parent, title, OSXFolderDialog.getInitialMode());
        mrjVersion = OSXFolderDialog.loadMRJVersion();
        if (mrjVersion == -1.0f) {
            this.setFile("-");
        }
        this.modeCheckingEnabled = true;
    }

    @Override
    public String getFile() {
        return super.getFile() != null ? "" : null;
    }

    @Override
    public String getDirectory() {
        String path = super.getDirectory();
        if (path == null) {
            return null;
        }
        if (mrjVersion >= 3.0f && super.getFile() != null) {
            return new File(path, super.getFile()).getPath();
        }
        return path;
    }

    @Override
    public void setMode(int mode) {
        if (this.modeCheckingEnabled) {
            throw new Error("can't set mode");
        }
        super.setMode(mode);
    }

    @Override
    public void show() {
        String prop = null;
        if (mrjVersion >= 4.0f) {
            prop = "apple.awt.fileDialogForDirectories";
        }
        Properties props = System.getProperties();
        Object oldValue = null;
        if (prop != null) {
            oldValue = props.get(prop);
            props.put(prop, "true");
        }
        super.show();
        if (prop != null) {
            if (oldValue == null) {
                props.remove(prop);
            } else {
                props.put(prop, oldValue);
            }
        }
    }

    private static int getInitialMode() {
        mrjVersion = OSXFolderDialog.loadMRJVersion();
        if (mrjVersion >= 4.0f) {
            return 0;
        }
        if (mrjVersion != -1.0f) {
            return 3;
        }
        return 1;
    }

    private static float loadMRJVersion() {
        String prop = System.getProperty("mrj.version");
        if (prop != null) {
            int st = 0;
            int dash = prop.indexOf(45);
            if (dash != -1 && dash != prop.length() - 1) {
                st = dash + 1;
            }
            int en = prop.length();
            int dot = prop.indexOf(46, st);
            if (dot != -1 && dot != prop.length() - 1) {
                dot = prop.indexOf(46, dot + 1);
            }
            if (dot != -1) {
                en = dot;
            }
            mrjVersion = new Float(prop.substring(st, en)).floatValue();
        }
        return mrjVersion;
    }
}

