/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.swing.Icon;
import org.jdesktop.application.Resource;
import org.limewire.core.api.Category;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.inject.LazySingleton;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.IconManager;
import org.limewire.util.OSUtils;

@LazySingleton
public class CategoryIconManager {
    private Icon audioIcon;
    private Icon imageIcon;
    private Icon videoIcon;
    private Icon documentIcon;
    private Icon programIcon;
    private Icon otherIcon;
    @Resource
    private Icon smallAudioIcon;
    @Resource
    private Icon smallImageIcon;
    @Resource
    private Icon smallVideoIcon;
    @Resource
    private Icon smallDocumentIcon;
    @Resource
    private Icon smallProgramIconWinVista;
    @Resource
    private Icon smallProgramIconWinXP;
    @Resource
    private Icon smallProgramIconOSX;
    @Resource
    private Icon smallProgramIconLinux;
    @Resource
    private Icon smallOtherIcon;
    private final Provider<IconManager> iconManager;

    @Inject
    CategoryIconManager(Provider<IconManager> iconManager) {
        this.iconManager = iconManager;
        GuiUtils.assignResources(this);
        this.audioIcon = this.smallAudioIcon;
        this.imageIcon = this.smallImageIcon;
        this.videoIcon = this.smallVideoIcon;
        this.documentIcon = this.smallDocumentIcon;
        this.otherIcon = this.smallOtherIcon;
        this.programIcon = OSUtils.isMacOSX() ? this.smallProgramIconOSX : (OSUtils.isWindowsVista() ? this.smallProgramIconWinVista : (OSUtils.isWindowsXP() ? this.smallProgramIconWinXP : this.smallProgramIconLinux));
    }

    public Icon getIcon(Category category) {
        switch (category) {
            case AUDIO: {
                return this.audioIcon;
            }
            case DOCUMENT: {
                return this.documentIcon;
            }
            case IMAGE: {
                return this.imageIcon;
            }
            case VIDEO: {
                return this.videoIcon;
            }
            case PROGRAM: {
                return this.programIcon;
            }
        }
        return this.otherIcon;
    }

    public Icon getIcon(PropertiableFile file) {
        switch (file.getCategory()) {
            case DOCUMENT: 
            case OTHER: {
                return this.iconManager.get().getIconForPropertiableFile(file);
            }
        }
        return this.getIcon(file.getCategory());
    }
}

