/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import com.google.inject.Inject;
import java.io.File;
import javax.swing.Icon;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.ui.swing.util.CategoryIconManager;
import org.limewire.ui.swing.util.NonBlockFileIconController;
import org.limewire.util.FileUtils;

public class BasicFileIconController
extends NonBlockFileIconController {
    private final CategoryIconManager categoryIconManager;
    private final CategoryManager categoryManager;

    @Inject
    public BasicFileIconController(CategoryIconManager categoryIconManager, CategoryManager categoryManager) {
        this.categoryIconManager = categoryIconManager;
        this.categoryManager = categoryManager;
    }

    @Override
    public Icon getIconForFile(File f) {
        if (f == null) {
            return null;
        }
        String extension = FileUtils.getFileExtension(f);
        return this.getIconForExtension(extension);
    }

    @Override
    public Icon getIconForExtension(String ext) {
        Category category = null;
        if (ext != null) {
            category = this.categoryManager.getCategoryForExtension(ext);
        }
        return this.categoryIconManager.getIcon(category);
    }

    @Override
    public boolean isIconForFileAvailable(File f) {
        return true;
    }
}

