/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.upload.table;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellEditor;
import org.limewire.core.api.Category;
import org.limewire.core.api.endpoint.RemoteHost;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.core.api.upload.UploadItem;
import org.limewire.ui.swing.library.table.ListMenuFactory;
import org.limewire.ui.swing.search.BlockUserMenuFactory;
import org.limewire.ui.swing.search.RemoteHostMenuFactory;
import org.limewire.ui.swing.upload.UploadMediator;
import org.limewire.ui.swing.upload.table.FinishedUploadSelected;
import org.limewire.ui.swing.upload.table.UploadActionHandler;
import org.limewire.ui.swing.upload.table.UploadTable;
import org.limewire.ui.swing.util.I18n;

public class UploadPopupMenu
extends JPopupMenu {
    private final UploadTable table;
    private final List<UploadItem> uploadItems;
    private final Provider<List<File>> selectedFiles;
    private final UploadActionHandler actionHandler;
    private final LibraryManager libraryManager;
    private final RemoteHostMenuFactory browseMenuFactory;
    private final BlockUserMenuFactory blockUserMenuFactory;
    private final ListMenuFactory listMenuFactory;
    private Collection<RemoteHost> remoteHosts;

    @Inject
    public UploadPopupMenu(@Assisted UploadTable table, @Assisted List<UploadItem> uploadItems, @FinishedUploadSelected Provider<List<File>> selectedFiles, UploadActionHandler actionHandler, LibraryManager libraryManager, RemoteHostMenuFactory browseMenuFactory, BlockUserMenuFactory blockUserMenuFactory, ListMenuFactory listMenuFactory) {
        this.table = table;
        this.uploadItems = uploadItems;
        this.selectedFiles = selectedFiles;
        this.actionHandler = actionHandler;
        this.libraryManager = libraryManager;
        this.browseMenuFactory = browseMenuFactory;
        this.blockUserMenuFactory = blockUserMenuFactory;
        this.listMenuFactory = listMenuFactory;
        this.createMenu();
    }

    private void createMenu() {
        int itemCount = this.uploadItems.size();
        if (itemCount == 0) {
            throw new IllegalStateException(I18n.tr("No selected items"));
        }
        if (itemCount == 1) {
            UploadItem item = this.uploadItems.get(0);
            switch (item.getUploadItemType()) {
                case GNUTELLA: {
                    this.createSingleGnutellaMenu(item);
                    break;
                }
                case BITTORRENT: {
                    this.createSingleTorrentMenu(item);
                    break;
                }
                default: {
                    throw new IllegalStateException(I18n.tr("Unknown upload type: " + (Object)((Object)item.getUploadItemType())));
                }
            }
        } else {
            this.createMultipleItemMenu();
        }
    }

    private void createSingleGnutellaMenu(UploadItem uploadItem) {
        DefaultMenuListener listener = new DefaultMenuListener();
        boolean done = UploadMediator.isRemovable(uploadItem);
        boolean browseItem = UploadMediator.isBrowseHost(uploadItem);
        if (done) {
            this.add(this.createRemoveMenuItem());
        } else {
            this.add(this.createCancelMenuItem(listener));
        }
        if (!browseItem) {
            if (this.getComponentCount() > 0) {
                this.addSeparator();
            }
            JMenuItem launchMenuItem = new JMenuItem(I18n.tr("Play/Open"));
            launchMenuItem.setActionCommand(this.isPlayable(uploadItem.getCategory()) ? "play" : "launch");
            launchMenuItem.addActionListener(listener);
            this.add(launchMenuItem);
            JMenuItem locateOnDiskMenuItem = new JMenuItem(I18n.tr("Locate on Disk"));
            locateOnDiskMenuItem.setActionCommand("locate");
            locateOnDiskMenuItem.addActionListener(listener);
            this.add(locateOnDiskMenuItem);
            JMenuItem showInLibraryMenuItem = new JMenuItem(I18n.tr("Locate in Library"));
            showInLibraryMenuItem.setActionCommand("library");
            showInLibraryMenuItem.addActionListener(listener);
            this.add(showInLibraryMenuItem).setEnabled(this.libraryManager.getLibraryManagedList().contains(uploadItem.getUrn()));
        }
        if (done && !browseItem) {
            this.addSeparator();
            JMenu addToListMenu = this.listMenuFactory.createAddToListMenu(this.selectedFiles);
            this.add(addToListMenu);
            JMenu showInListMenu = this.listMenuFactory.createShowInListMenu(this.selectedFiles, true);
            this.add(showInListMenu);
        }
        this.addSeparator();
        JMenu browseMenu = this.browseMenuFactory.createBrowseMenu(this.getRemoteHosts());
        this.add(browseMenu);
        JMenu blockMenu = this.blockUserMenuFactory.createDownloadBlockMenu(this.getRemoteHosts());
        if (blockMenu != null) {
            this.add(blockMenu);
        }
        if (!browseItem) {
            this.addSeparator();
            this.add(this.createFileInfoMenuItem(listener));
        }
    }

    private void createSingleTorrentMenu(UploadItem uploadItem) {
        DefaultMenuListener listener = new DefaultMenuListener();
        boolean done = UploadMediator.isRemovable(uploadItem);
        boolean browseItem = UploadMediator.isBrowseHost(uploadItem);
        boolean pausable = UploadMediator.isPausable(uploadItem);
        boolean resumable = UploadMediator.isResumable(uploadItem);
        if (pausable) {
            this.add(this.createPauseMenuItem());
        }
        if (resumable) {
            this.add(this.createResumeMenuItem());
        }
        if (done) {
            this.add(this.createRemoveMenuItem());
        } else {
            this.add(this.createCancelMenuItem(listener));
        }
        if (!browseItem) {
            if (this.getComponentCount() > 0) {
                this.addSeparator();
            }
            JMenuItem locateOnDiskMenuItem = new JMenuItem(I18n.tr("Locate on Disk"));
            locateOnDiskMenuItem.setActionCommand("locate");
            locateOnDiskMenuItem.addActionListener(listener);
            this.add(locateOnDiskMenuItem);
        }
        if (done) {
            if (this.getComponentCount() > 0) {
                this.addSeparator();
            }
            JMenu addToListMenu = this.listMenuFactory.createAddToListMenu(this.selectedFiles);
            this.add(addToListMenu);
        }
        if (!browseItem) {
            if (this.getComponentCount() > 0) {
                this.addSeparator();
            }
            this.add(this.createFileInfoMenuItem(listener));
        }
    }

    private void createMultipleItemMenu() {
        boolean allBrowse = this.isAllBrowse();
        boolean allDone = this.isAllDone();
        boolean anyPausable = this.isAnyPausable();
        boolean anyResumable = this.isAnyResumable();
        if (!allDone) {
            if (anyPausable) {
                this.add(this.createPauseMenuItem());
            }
            if (anyResumable) {
                this.add(this.createResumeMenuItem());
            }
        }
        if (allDone || this.isAnyRemovable()) {
            this.add(this.createRemoveMenuItem());
        }
        if (!allDone) {
            if (this.getComponentCount() > 0) {
                this.addSeparator();
            }
            JMenu browseMenu = this.browseMenuFactory.createBrowseMenu(this.getRemoteHosts());
            this.add(browseMenu);
            JMenu blockMenu = this.blockUserMenuFactory.createDownloadBlockMenu(this.getRemoteHosts());
            if (blockMenu != null) {
                this.add(blockMenu);
            }
            this.addSeparator();
            this.add(this.createCancelMenuItem(new DefaultMenuListener()));
        } else if (!allBrowse) {
            if (this.getComponentCount() > 0) {
                this.addSeparator();
            }
            JMenu addToListMenu = this.listMenuFactory.createAddToListMenu(this.selectedFiles);
            this.add(addToListMenu);
        }
    }

    private JMenuItem createCancelMenuItem(ActionListener listener) {
        JMenuItem menuItem = new JMenuItem(I18n.tr("Cancel"));
        menuItem.setActionCommand("cancel");
        menuItem.addActionListener(listener);
        return menuItem;
    }

    private JMenuItem createRemoveMenuItem() {
        JMenuItem menuItem = new JMenuItem(I18n.tr("Clear from Tray"));
        menuItem.setActionCommand("remove");
        menuItem.addActionListener(new RemoveMenuListener());
        return menuItem;
    }

    private JMenuItem createPauseMenuItem() {
        JMenuItem menuItem = new JMenuItem(I18n.tr("Pause"));
        menuItem.setActionCommand("pause");
        menuItem.addActionListener(new PauseMenuListener());
        return menuItem;
    }

    private JMenuItem createResumeMenuItem() {
        JMenuItem menuItem = new JMenuItem(I18n.tr("Resume"));
        menuItem.setActionCommand("resume");
        menuItem.addActionListener(new ResumeMenuListener());
        return menuItem;
    }

    private JMenuItem createFileInfoMenuItem(ActionListener listener) {
        JMenuItem menuItem = new JMenuItem(I18n.tr("View File Info..."));
        menuItem.setActionCommand("properties");
        menuItem.addActionListener(listener);
        return menuItem;
    }

    private Collection<RemoteHost> getRemoteHosts() {
        if (this.remoteHosts == null) {
            this.remoteHosts = new ArrayList<RemoteHost>();
            for (UploadItem item : this.uploadItems) {
                if (item.getUploadItemType() == UploadItem.UploadItemType.BITTORRENT) continue;
                this.remoteHosts.add(item.getRemoteHost());
            }
        }
        return this.remoteHosts;
    }

    private boolean isAllBrowse() {
        for (UploadItem item : this.uploadItems) {
            if (UploadMediator.isBrowseHost(item)) continue;
            return false;
        }
        return true;
    }

    private boolean isAllDone() {
        for (UploadItem item : this.uploadItems) {
            if (UploadMediator.isRemovable(item)) continue;
            return false;
        }
        return true;
    }

    private boolean isAnyPausable() {
        for (UploadItem item : this.uploadItems) {
            if (!UploadMediator.isPausable(item)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnyResumable() {
        for (UploadItem item : this.uploadItems) {
            if (!UploadMediator.isResumable(item)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnyRemovable() {
        for (UploadItem item : this.uploadItems) {
            if (!UploadMediator.isRemovable(item)) continue;
            return true;
        }
        return false;
    }

    private boolean isPlayable(Category category) {
        return category == Category.AUDIO || category == Category.VIDEO;
    }

    private void cancelEditing() {
        Component comp = this.table.getEditorComponent();
        if (comp instanceof TableCellEditor) {
            ((TableCellEditor)((Object)comp)).cancelCellEditing();
        }
    }

    private abstract class MenuListener
    implements ActionListener {
        private MenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (UploadItem item : UploadPopupMenu.this.uploadItems) {
                if (!this.isValid(item)) continue;
                UploadPopupMenu.this.actionHandler.performAction(e.getActionCommand(), item);
            }
            UploadPopupMenu.this.cancelEditing();
        }

        protected abstract boolean isValid(UploadItem var1);
    }

    private class RemoveMenuListener
    extends MenuListener {
        private RemoveMenuListener() {
        }

        @Override
        protected boolean isValid(UploadItem item) {
            return UploadMediator.isRemovable(item);
        }
    }

    private class ResumeMenuListener
    extends MenuListener {
        private ResumeMenuListener() {
        }

        @Override
        protected boolean isValid(UploadItem item) {
            return UploadMediator.isResumable(item);
        }
    }

    private class PauseMenuListener
    extends MenuListener {
        private PauseMenuListener() {
        }

        @Override
        protected boolean isValid(UploadItem item) {
            return UploadMediator.isPausable(item);
        }
    }

    private class DefaultMenuListener
    extends MenuListener {
        private DefaultMenuListener() {
        }

        @Override
        protected boolean isValid(UploadItem item) {
            return true;
        }
    }
}

