/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.upload.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;
import org.limewire.core.api.upload.UploadItem;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.table.TableRendererEditor;
import org.limewire.ui.swing.transfer.TransferRendererResources;
import org.limewire.ui.swing.upload.UploadMediator;
import org.limewire.ui.swing.upload.table.UploadActionHandler;
import org.limewire.ui.swing.util.I18n;

class UploadActionRendererEditor
extends TableRendererEditor {
    private final UploadActionHandler actionHandler;
    private final JButton pauseButton;
    private final JButton resumeButton;
    private UploadItem item;

    public UploadActionRendererEditor(UploadActionHandler actionHandler) {
        this.actionHandler = actionHandler;
        this.setLayout(new BorderLayout());
        TransferRendererResources resources = new TransferRendererResources();
        this.pauseButton = new HyperlinkButton(I18n.tr("Pause"));
        this.pauseButton.setActionCommand("pause");
        this.pauseButton.setFont(resources.getFont());
        this.pauseButton.setToolTipText(I18n.tr("Pause upload"));
        this.resumeButton = new HyperlinkButton(I18n.tr("Resume"));
        this.resumeButton.setActionCommand("resume");
        this.resumeButton.setFont(resources.getFont());
        this.resumeButton.setToolTipText(I18n.tr("Resume upload"));
        if (actionHandler != null) {
            ButtonListener listener = new ButtonListener();
            this.pauseButton.addActionListener(listener);
            this.resumeButton.addActionListener(listener);
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new MigLayout("insets 0 0 0 0, gap 0, novisualpadding, fill, aligny center"));
        buttonPanel.setOpaque(false);
        buttonPanel.add((Component)this.pauseButton, "hidemode 3");
        buttonPanel.add((Component)this.resumeButton, "hidemode 3");
        this.add((Component)buttonPanel, "Center");
    }

    @Override
    protected Component doTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof UploadItem) {
            this.item = (UploadItem)value;
            this.updateButtons(this.item);
            return this;
        }
        return this.emptyPanel;
    }

    @Override
    protected Component doTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof UploadItem) {
            this.updateButtons((UploadItem)value);
            return this;
        }
        return this.emptyPanel;
    }

    @Override
    public final boolean shouldSelectCell(EventObject e) {
        return true;
    }

    private void updateButtons(UploadItem uploadItem) {
        this.pauseButton.setVisible(UploadMediator.isPausable(uploadItem));
        this.resumeButton.setVisible(UploadMediator.isResumable(uploadItem));
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UploadActionRendererEditor.this.actionHandler.performAction(e.getActionCommand(), UploadActionRendererEditor.this.item);
            UploadActionRendererEditor.this.cancelCellEditing();
        }
    }
}

