/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.shell;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jdic.filetypes.Action;
import org.jdesktop.jdic.filetypes.Association;
import org.jdesktop.jdic.filetypes.AssociationAlreadyRegisteredException;
import org.jdesktop.jdic.filetypes.AssociationNotRegisteredException;
import org.jdesktop.jdic.filetypes.AssociationService;
import org.jdesktop.jdic.filetypes.RegisterFailedException;
import org.limewire.ui.swing.shell.ShellAssociation;
import org.limewire.util.SystemUtils;

public class FileTypeAssociation
implements ShellAssociation {
    private static final Log LOG = LogFactory.getLog(FileTypeAssociation.class);
    private static final AssociationService SERVICE = new AssociationService();
    private final String extention;
    private final String mimeType;
    private final String executable;
    private final String verb;
    private final Association association = new Association();

    public FileTypeAssociation(String extention, String mimeType, String executable, String verb, String description, String iconPath) {
        this.extention = extention;
        this.mimeType = mimeType;
        this.executable = executable;
        this.verb = verb;
        Action action = new Action(verb, executable);
        this.association.addAction(action);
        this.association.addFileExtension(extention);
        this.association.setMimeType(mimeType);
        this.association.setName(description);
        this.association.setDescription(description);
        if (iconPath != null) {
            this.association.setIconFileName(iconPath);
        }
    }

    @Override
    public boolean isAvailable() {
        try {
            Association f = SERVICE.getFileExtensionAssociation(this.extention);
            if (f == null && f == SERVICE.getMimeTypeAssociation(this.mimeType)) {
                return true;
            }
        }
        catch (IllegalArgumentException iae) {
            LOG.warn("Can't check availability!", iae);
            return true;
        }
        String extHandler = SystemUtils.getDefaultExtentionHandler(this.extention);
        return "".equals(extHandler) && "".equals(SystemUtils.getDefaultMimeHandler(this.mimeType));
    }

    @Override
    public boolean isRegistered() {
        Association f;
        try {
            f = SERVICE.getFileExtensionAssociation(this.extention);
        }
        catch (IllegalArgumentException iae) {
            LOG.warn("Can't check registration!", iae);
            return false;
        }
        if (f == null) {
            return false;
        }
        Action open = f.getActionByVerb(this.verb);
        if (open == null) {
            return false;
        }
        if (this.executable.equals(open.getCommand())) {
            return true;
        }
        return this.executable.equals(SystemUtils.getDefaultExtentionHandler(this.extention)) && this.executable.equals(SystemUtils.getDefaultMimeHandler(this.mimeType));
    }

    @Override
    public void register() {
        try {
            SERVICE.registerUserAssociation(this.association);
            SystemUtils.flushIconCache();
        }
        catch (AssociationAlreadyRegisteredException ignore) {
            LOG.error("can't register", ignore);
        }
        catch (RegisterFailedException ignore) {
            LOG.error("can't register", ignore);
        }
    }

    @Override
    public boolean canUnregister() {
        return true;
    }

    @Override
    public void unregister() {
        try {
            this.forceUnregister(SERVICE.getFileExtensionAssociation(this.extention));
            this.forceUnregister(SERVICE.getMimeTypeAssociation(this.extention));
        }
        catch (IllegalArgumentException ignored) {
            LOG.warn("Can't unregister!", ignored);
        }
    }

    private void forceUnregister(Association f) {
        if (f == null) {
            return;
        }
        try {
            SERVICE.unregisterUserAssociation(f);
            SystemUtils.flushIconCache();
        }
        catch (AssociationNotRegisteredException ignore) {
            LOG.error("can't unregister", ignore);
        }
        catch (RegisterFailedException ignore) {
            LOG.error("can't unregister", ignore);
        }
    }

    public String toString() {
        return this.extention + ":" + this.mimeType + ":" + this.executable + ":" + this.verb;
    }
}

