/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.resultpanel;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.resultpanel.ResultsTableFormat;
import org.limewire.ui.swing.search.resultpanel.classic.AllTableFormat;
import org.limewire.ui.swing.search.resultpanel.classic.AudioTableFormat;
import org.limewire.ui.swing.search.resultpanel.classic.DocumentTableFormat;
import org.limewire.ui.swing.search.resultpanel.classic.ImageTableFormat;
import org.limewire.ui.swing.search.resultpanel.classic.OtherTableFormat;
import org.limewire.ui.swing.search.resultpanel.classic.ProgramTableFormat;
import org.limewire.ui.swing.search.resultpanel.classic.VideoTableFormat;
import org.limewire.ui.swing.util.IconManager;

public class ResultsTableFormatFactory {
    private final Provider<IconManager> iconManager;

    @Inject
    public ResultsTableFormatFactory(Provider<IconManager> iconManager) {
        this.iconManager = iconManager;
    }

    public ResultsTableFormat<VisualSearchResult> createTableFormat(SearchCategory searchCategory) {
        switch (searchCategory) {
            case ALL: {
                return new AllTableFormat(this.iconManager);
            }
            case AUDIO: {
                return new AudioTableFormat();
            }
            case VIDEO: {
                return new VideoTableFormat();
            }
            case DOCUMENT: {
                return new DocumentTableFormat(this.iconManager);
            }
            case IMAGE: {
                return new ImageTableFormat();
            }
            case PROGRAM: {
                return new ProgramTableFormat();
            }
            case OTHER: {
                return new OtherTableFormat();
            }
        }
        throw new IllegalArgumentException("Invalid search category " + (Object)((Object)searchCategory));
    }
}

