/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.resultpanel;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import org.limewire.ui.swing.listener.MousePopupListener;
import org.limewire.ui.swing.search.SearchInspectionUtils;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.resultpanel.ResultsTableFormat;
import org.limewire.ui.swing.table.ColumnStateHandler;
import org.limewire.ui.swing.table.MouseableTable;
import org.limewire.ui.swing.table.TableColumnSelector;

public class ResultsTable<E extends VisualSearchResult>
extends MouseableTable {
    private EventList<E> eventList;
    private ResultsTableFormat<E> tableFormat;
    private DefaultEventTableModel<E> tableModel;
    private ColumnStateHandler columnStateHandler;
    private MousePopupListener mousePopupListener;

    public ResultsTable() {
        this.setShowHorizontalLines(false);
        this.setShowGrid(false, true);
    }

    public DefaultEventTableModel<E> getEventTableModel() {
        return this.tableModel;
    }

    public void setEventListFormat(EventList<E> eventList, ResultsTableFormat<E> tableFormat, boolean showHeader) {
        this.uninstallListeners();
        if (this.tableModel != null) {
            this.tableModel.dispose();
        }
        if (this.eventList instanceof TransformedList) {
            ((TransformedList)this.eventList).dispose();
        }
        this.eventList = eventList;
        this.tableFormat = tableFormat;
        this.tableModel = new DefaultEventTableModel<E>(eventList, tableFormat);
        this.setModel(this.tableModel);
        this.installListeners(showHeader);
    }

    private void installListeners(boolean showHeader) {
        if (showHeader) {
            JTableHeader tableHeader = this.getTableHeader();
            if (tableHeader == null) {
                tableHeader = this.createDefaultTableHeader();
                this.setTableHeader(tableHeader);
            }
            this.mousePopupListener = new MousePopupListener(){

                @Override
                public void handlePopupMouseEvent(MouseEvent e) {
                    JPopupMenu popupMenu = ResultsTable.this.createHeaderPopupMenu();
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            };
            tableHeader.addMouseListener(this.mousePopupListener);
            this.columnStateHandler = new ColumnStateHandler(this, this.tableFormat);
            tableHeader.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SearchInspectionUtils.searchSorted();
                }
            });
        } else {
            this.columnStateHandler = null;
            this.mousePopupListener = null;
            this.setTableHeader(null);
        }
    }

    private void uninstallListeners() {
        if (this.getTableHeader() != null) {
            this.getTableHeader().removeMouseListener(this.mousePopupListener);
        }
        if (this.columnStateHandler != null) {
            this.columnStateHandler.removeListeners();
        }
    }

    private JPopupMenu createHeaderPopupMenu() {
        TableColumnSelector columnSelector = new TableColumnSelector(this, this.tableFormat);
        return columnSelector.getPopupMenu();
    }

    public void applySavedColumnSettings() {
        if (this.columnStateHandler != null) {
            this.columnStateHandler.setupColumnWidths();
            this.columnStateHandler.setupColumnVisibility(false);
            this.columnStateHandler.setupColumnOrder();
        }
    }
}

