/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Scrollable;
import org.jdesktop.swingx.JXPanel;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.ui.swing.search.SearchViewType;
import org.limewire.ui.swing.search.model.SearchResultsModel;
import org.limewire.ui.swing.search.resultpanel.BaseResultPanel;
import org.limewire.ui.swing.search.resultpanel.BaseResultPanelFactory;
import org.limewire.ui.swing.settings.SwingUiSettings;

public class ResultsContainer
extends JXPanel {
    private final BaseResultPanel baseResultPanel;

    @Inject
    ResultsContainer(@Assisted SearchResultsModel searchResultsModel, BaseResultPanelFactory baseFactory) {
        this.baseResultPanel = baseFactory.create(searchResultsModel);
        this.baseResultPanel.setViewType(SearchViewType.forId(SwingUiSettings.SEARCH_VIEW_TYPE_ID.getValue()));
        this.setLayout(new BorderLayout());
        this.add((Component)this.baseResultPanel, "Center");
    }

    public void setViewType(SearchViewType mode) {
        this.baseResultPanel.setViewType(mode);
    }

    public void showCategory(SearchCategory category) {
        this.baseResultPanel.showCategory(category);
    }

    public Component getScrollPaneHeader() {
        return this.baseResultPanel.getScrollPaneHeader();
    }

    public Scrollable getScrollable() {
        return this.baseResultPanel.getScrollable();
    }
}

