/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.limewire.core.api.search.SearchDetails;
import org.limewire.core.api.search.browse.BrowseSearch;
import org.limewire.core.api.search.browse.BrowseSearchFactory;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendPresence;
import org.limewire.inject.LazySingleton;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.friends.chat.ChatMediator;
import org.limewire.ui.swing.friends.refresh.AllFriendsRefreshManager;
import org.limewire.ui.swing.nav.NavItemListener;
import org.limewire.ui.swing.nav.Navigator;
import org.limewire.ui.swing.search.BrowsePanelFactory;
import org.limewire.ui.swing.search.DefaultSearchInfo;
import org.limewire.ui.swing.search.FriendPresenceActions;
import org.limewire.ui.swing.search.SearchInfo;
import org.limewire.ui.swing.search.SearchNavItem;
import org.limewire.ui.swing.search.SearchNavigator;
import org.limewire.ui.swing.search.SearchResultsPanel;
import org.limewire.ui.swing.search.SwingSearchListener;
import org.limewire.ui.swing.util.I18n;

@LazySingleton
class FriendPresenceActionsImpl
implements FriendPresenceActions {
    private static final Log LOG = LogFactory.getLog(FriendPresenceActionsImpl.class);
    @InspectablePrimitive(value="browse all friends", category=DataCategory.USAGE)
    private int numBrowseAll;
    @InspectablePrimitive(value="browse single friend", category=DataCategory.USAGE)
    private int numBrowseFriend;
    @InspectablePrimitive(value="browse host", category=DataCategory.USAGE)
    private int numBrowseHost;
    private final Provider<ChatMediator> chatMediator;
    private final Provider<SearchNavigator> searchNavigator;
    private final Provider<BrowseSearchFactory> browseSearchFactory;
    private final BrowsePanelFactory browsePanelFactory;
    private final Map<String, SearchNavItem> browseNavItemCache = new HashMap<String, SearchNavItem>();
    private final AllFriendsRefreshManager allFriendsRefreshManager;
    private static final String ALL_FRIENDS_KEY = "ALL_FRIENDS";

    @Inject
    public FriendPresenceActionsImpl(Provider<ChatMediator> chatMediator, BrowsePanelFactory browsePanelFactory, Provider<SearchNavigator> searchNavigator, Navigator navigator, Provider<BrowseSearchFactory> browseSearchFactory, AllFriendsRefreshManager allFriendsRefreshManager) {
        this.chatMediator = chatMediator;
        this.browsePanelFactory = browsePanelFactory;
        this.searchNavigator = searchNavigator;
        this.browseSearchFactory = browseSearchFactory;
        this.allFriendsRefreshManager = allFriendsRefreshManager;
    }

    @Override
    public void chatWith(Friend friend) {
        LOG.debugf("chatWith: {0}", (Object)friend);
        this.chatMediator.get().startOrSelectConversation(friend.getId());
    }

    @Override
    public void viewFriendLibrary(Friend friend) {
        ++this.numBrowseFriend;
        assert (friend != null && !friend.isAnonymous());
        LOG.debugf("viewLibraryOf: {0}", (Object)friend);
        if (this.navigateIfTabExists(friend.getId())) {
            return;
        }
        this.browse(this.browseSearchFactory.get().createFriendBrowseSearch(friend), DefaultSearchInfo.createBrowseSearch(SearchDetails.SearchType.SINGLE_BROWSE), friend.getRenderName(), friend.getId());
    }

    @Override
    public void viewLibrariesOf(Collection<FriendPresence> people) {
        this.numBrowseHost += people.size();
        if (people.size() == 1) {
            FriendPresence person = people.iterator().next();
            if (!this.navigateIfTabExists(person.getFriend().getId())) {
                this.browse(this.browseSearchFactory.get().createBrowseSearch(person), DefaultSearchInfo.createBrowseSearch(SearchDetails.SearchType.SINGLE_BROWSE), person.getFriend().getRenderName(), person.getFriend().getId());
            }
        } else if (!people.isEmpty()) {
            this.browse(this.browseSearchFactory.get().createBrowseSearch(people), DefaultSearchInfo.createBrowseSearch(SearchDetails.SearchType.MULTIPLE_BROWSE), this.getTabTitle(people), null);
        }
    }

    @Override
    public void browseAllFriends(boolean forceRefresh) {
        ++this.numBrowseAll;
        if (this.navigateIfTabExists(ALL_FRIENDS_KEY)) {
            if (forceRefresh) {
                this.allFriendsRefreshManager.refresh();
            }
            return;
        }
        this.browse(this.browseSearchFactory.get().createAllFriendsBrowseSearch(), DefaultSearchInfo.createBrowseSearch(SearchDetails.SearchType.ALL_FRIENDS_BROWSE), I18n.tr("All Friends"), ALL_FRIENDS_KEY);
    }

    private String getTabTitle(Collection<FriendPresence> people) {
        boolean hasP2P = this.hasP2P(people);
        boolean hasFriends = this.hasFriend(people);
        if (hasP2P && hasFriends) {
            return I18n.trn("{0} Person", "{0} People", people.size());
        }
        if (hasP2P) {
            return I18n.trn("{0} P2P User", "{0} P2P Users", people.size());
        }
        if (hasFriends) {
            return I18n.trn("{0} Friend", "{0} Friends", people.size());
        }
        return "";
    }

    private boolean hasP2P(Collection<FriendPresence> people) {
        for (FriendPresence host : people) {
            if (!host.getFriend().isAnonymous()) continue;
            return true;
        }
        return false;
    }

    private boolean hasFriend(Collection<FriendPresence> people) {
        for (FriendPresence host : people) {
            if (host.getFriend().isAnonymous()) continue;
            return true;
        }
        return false;
    }

    private void browse(BrowseSearch search, SearchInfo searchInfo, String title, String key) {
        SearchResultsPanel searchPanel = this.browsePanelFactory.createBrowsePanel(search, searchInfo);
        SearchNavItem item = this.searchNavigator.get().addSearch(title, (JComponent)searchPanel, search, searchPanel.getModel());
        item.select();
        searchPanel.getModel().start(new SwingSearchListener(searchPanel.getModel(), searchPanel, item));
        searchPanel.setBrowseTitle(title);
        if (key != null) {
            this.browseNavItemCache.put(key, item);
            item.addNavItemListener(new ItemRemovalListener(key));
        }
        if (key == ALL_FRIENDS_KEY) {
            this.allFriendsRefreshManager.registerBrowseSearch(search, searchPanel.getModel());
        }
    }

    private boolean navigateIfTabExists(String key) {
        if (key != null && this.browseNavItemCache.get(key) != null) {
            this.browseNavItemCache.get(key).select();
            return true;
        }
        return false;
    }

    private class ItemRemovalListener
    implements NavItemListener {
        private String key;

        public ItemRemovalListener(String key) {
            this.key = key;
        }

        @Override
        public void itemRemoved(boolean wasSelected) {
            FriendPresenceActionsImpl.this.browseNavItemCache.remove(this.key);
            if (this.key == FriendPresenceActionsImpl.ALL_FRIENDS_KEY) {
                FriendPresenceActionsImpl.this.allFriendsRefreshManager.clearBrowseSearch();
            }
        }

        @Override
        public void itemSelected(boolean selected) {
        }
    }
}

