/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.properties;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.FancyTab;
import org.limewire.ui.swing.components.FancyTabList;
import org.limewire.ui.swing.components.NoOpAction;
import org.limewire.ui.swing.components.TabActionMap;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

class FileInfoTabPanel {
    @Resource
    Color backgroundColor;
    @Resource
    Color borderColor;
    @Resource
    Font buttonFont;
    @Resource
    Color fontColor;
    @Resource
    Color fontSelectedColor;
    @Resource
    Color selectionTopGradientColor;
    @Resource
    Color selectionBottomGradientColor;
    @Resource
    Color selectionBorderTopColor;
    @Resource
    Color selectionBorderBottomColor;
    @Resource
    Color highlightBackgroundColor;
    @Resource
    Color highlightBorderColor;
    private final JPanel component;
    private final FancyTabList tabList;
    private final List<TabActionMap> tabActionMaps = new ArrayList<TabActionMap>();
    private final List<FileInfoTabListener> listeners;

    @Inject
    public FileInfoTabPanel() {
        this.component = new JPanel(new MigLayout("insets 0 14 0 5, gap 0, fill", "", "[28!]"));
        this.tabList = new FancyTabList(this.tabActionMaps);
        this.listeners = new CopyOnWriteArrayList<FileInfoTabListener>();
        GuiUtils.assignResources(this);
        this.init();
    }

    private void init() {
        this.component.setBackground(this.backgroundColor);
        this.component.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.borderColor));
        this.tabList.setSelectionPainter(new CategoryTabPainter(this.selectionTopGradientColor, this.selectionBottomGradientColor, this.selectionBorderTopColor, this.selectionBorderBottomColor));
        this.tabList.setHighlightPainter(new CategoryTabPainter(this.highlightBackgroundColor, this.highlightBackgroundColor, this.highlightBorderColor, this.highlightBorderColor));
        this.tabList.setTabTextColor(this.fontColor);
        this.tabList.setTextFont(this.buttonFont);
        this.tabList.setTabTextSelectedColor(this.fontSelectedColor);
        this.tabList.setUnderlineEnabled(false);
        this.component.add((Component)this.tabList, "growy");
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void addSearchTabListener(FileInfoTabListener listener) {
        this.listeners.add(listener);
    }

    public void setTabs(List<Tabs> tabs) {
        this.tabActionMaps.clear();
        for (Tabs tab : tabs) {
            this.addTab(tab);
        }
        this.tabList.setTabActionMaps(this.tabActionMaps);
    }

    private void addTab(Tabs tab) {
        FileInfoTabAction action = new FileInfoTabAction(tab);
        if (tab == Tabs.GENERAL) {
            action.putValue("SwingSelectedKey", true);
        }
        TabActionMap map = this.newTabActionMap(action);
        this.tabActionMaps.add(map);
    }

    private TabActionMap newTabActionMap(FileInfoTabAction action) {
        NoOpAction moreText = new NoOpAction();
        moreText.putValue("Name", "");
        return new TabActionMap(action, null, moreText, null);
    }

    private static class CategoryTabPainter
    extends RectanglePainter<FancyTab> {
        public CategoryTabPainter(Color topGradient, Color bottomGradient, Color topBorder, Color bottomBorder) {
            this.setFillPaint(new GradientPaint(0.0f, 0.0f, topGradient, 0.0f, 1.0f, bottomGradient));
            this.setBorderPaint(new GradientPaint(0.0f, 0.0f, topBorder, 0.0f, 1.0f, bottomBorder));
            this.setRoundHeight(10);
            this.setRoundWidth(10);
            this.setRounded(true);
            this.setPaintStretched(true);
            this.setInsets(new Insets(2, 0, 1, 0));
            this.setAntialiasing(true);
            this.setCacheable(true);
        }
    }

    private class FileInfoTabAction
    extends AbstractAction {
        private final Tabs tab;

        public FileInfoTabAction(Tabs tab) {
            super(tab.getName());
            this.tab = tab;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (FileInfoTabListener listener : FileInfoTabPanel.this.listeners) {
                listener.tabSelected(this.tab);
            }
        }
    }

    static interface FileInfoTabListener {
        public void tabSelected(Tabs var1);
    }

    static enum Tabs {
        GENERAL(I18n.tr("General")),
        SHARING(I18n.tr("Sharing")),
        TRACKERS(I18n.tr("Trackers")),
        TRANSFERS(I18n.tr("Transfers")),
        PIECES(I18n.tr("Pieces")),
        BITTORENT(I18n.tr("Files"));

        private final String name;

        private Tabs(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

