/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.properties;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.decorator.SortKey;
import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentEvent;
import org.limewire.bittorrent.TorrentEventType;
import org.limewire.bittorrent.TorrentFileEntry;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.listener.EventListener;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.properties.FileInfoPanel;
import org.limewire.ui.swing.properties.TorrentFileEntryWrapper;
import org.limewire.ui.swing.table.AbstractTableFormat;
import org.limewire.ui.swing.table.DefaultLimeTableCellRenderer;
import org.limewire.ui.swing.table.FileSizeRenderer;
import org.limewire.ui.swing.table.MouseableTable;
import org.limewire.ui.swing.table.TableCellHeaderRenderer;
import org.limewire.ui.swing.util.EventListJXTableSorting;
import org.limewire.ui.swing.util.EventListTableSortFormat;
import org.limewire.ui.swing.util.FontUtils;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.SwingUtils;
import org.limewire.util.Objects;

public class FileInfoBittorrentPanel
implements FileInfoPanel,
EventListener<TorrentEvent> {
    @Resource
    private Font selectFont;
    public static final String TORRENT_FILE_ENTRY_SELECTED = "torrentFileEntrySelected";
    private static final int DONT_DOWNLOAD = 0;
    private static final int LOWEST_PRIORITY = 1;
    private static final int NORMAL_PRIORITY = 2;
    private static final int HIGHEST_PRIORITY = 3;
    private final Torrent torrent;
    private final JPanel component;
    private BitTorrentTable table;
    private EventListJXTableSorting tableSorting;
    private EventList<TorrentFileEntryWrapper> eventList;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public FileInfoBittorrentPanel(Torrent torrent) {
        GuiUtils.assignResources(this);
        this.torrent = torrent;
        this.component = new JPanel(new MigLayout("fill", "[grow]", "[][grow]"));
        this.init();
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void updatePropertiableFile(PropertiableFile file) {
    }

    private void init() {
        this.component.setOpaque(false);
        ObservableElementList.Connector<TorrentFileEntryWrapper> torrentFileEntryConnector = GlazedLists.beanConnector(TorrentFileEntryWrapper.class);
        this.eventList = GlazedListsFactory.observableElementList(new BasicEventList(), torrentFileEntryConnector);
        List<TorrentFileEntry> fileEntries = this.torrent.getTorrentFileEntries();
        for (TorrentFileEntry entry : fileEntries) {
            this.eventList.add(new TorrentFileEntryWrapper(entry));
        }
        SortedList<TorrentFileEntryWrapper> sortedList = GlazedListsFactory.sortedList(this.eventList, null);
        BitTorrentTableFormat tableFormat = new BitTorrentTableFormat();
        this.table = new BitTorrentTable(new DefaultEventTableModel<TorrentFileEntryWrapper>(sortedList, tableFormat));
        this.tableSorting = EventListJXTableSorting.install(this.table, sortedList, tableFormat);
        JLabel selectLabel = new JLabel(I18n.tr("Select"));
        selectLabel.setFont(this.selectFont);
        HyperlinkButton allButton = new HyperlinkButton(new SelectAll(I18n.tr("all")));
        allButton.setFont(this.selectFont);
        HyperlinkButton noneButton = new HyperlinkButton(new SelectNone(I18n.tr("none")));
        noneButton.setFont(this.selectFont);
        this.component.add((Component)selectLabel, "gapleft 5, gaptop 2, split 3");
        this.component.add((Component)allButton, "gapleft 6, gaptop 2");
        this.component.add((Component)noneButton, "gapleft 6, gaptop 2, wrap");
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.configureEnclosingScrollPane(scrollPane);
        this.component.add((Component)scrollPane, "grow");
        this.torrent.addListener(this);
    }

    @Override
    public boolean hasChanged() {
        boolean hasChanged = false;
        for (TorrentFileEntryWrapper wrapper : this.eventList) {
            if (!wrapper.hasChanged()) continue;
            hasChanged = true;
            break;
        }
        return hasChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        this.torrent.getLock().lock();
        try {
            if (this.hasChanged() && !this.torrent.isFinished() && this.torrent.isValid()) {
                for (TorrentFileEntryWrapper wrapper : this.eventList) {
                    this.torrent.setTorrenFileEntryPriority(wrapper.getTorrentFileEntry(), wrapper.getPriority());
                }
            }
        }
        finally {
            this.torrent.getLock().unlock();
        }
    }

    @Override
    public void dispose() {
        this.tableSorting.uninstall();
        this.torrent.removeListener(this);
    }

    protected void configureEnclosingScrollPane(JScrollPane scrollPane) {
        JTableHeader th = new JTableHeader();
        th.setDefaultRenderer(new TableCellHeaderRenderer());
        Component renderer = th.getDefaultRenderer().getTableCellRendererComponent(null, "", false, false, -1, -1);
        JPanel cornerComponent = new JPanel(new BorderLayout());
        cornerComponent.add(renderer, "Center");
        scrollPane.setCorner("UPPER_RIGHT_CORNER", cornerComponent);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void handleEvent(TorrentEvent event) {
        if (event.getType() == TorrentEventType.STATUS_CHANGED || event.getType() == TorrentEventType.COMPLETED) {
            SwingUtils.invokeNowOrLater(new Runnable(){

                @Override
                public void run() {
                    List<TorrentFileEntry> fileEntries = FileInfoBittorrentPanel.this.torrent.getTorrentFileEntries();
                    for (TorrentFileEntry newEntry : fileEntries) {
                        TorrentFileEntryWrapper wrapper = (TorrentFileEntryWrapper)FileInfoBittorrentPanel.this.eventList.get(newEntry.getIndex());
                        wrapper.setTorrentFileEntry(newEntry);
                    }
                }
            });
        }
    }

    private final class SelectAll
    extends AbstractAction {
        private SelectAll(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            FileInfoBittorrentPanel.this.torrent.getLock().lock();
            try {
                if (!FileInfoBittorrentPanel.this.torrent.isFinished()) {
                    for (TorrentFileEntryWrapper wrapper : FileInfoBittorrentPanel.this.eventList) {
                        if (wrapper.getPriority() != 0) continue;
                        wrapper.setPriority(1);
                    }
                }
            }
            finally {
                FileInfoBittorrentPanel.this.torrent.getLock().unlock();
            }
            FileInfoBittorrentPanel.this.table.repaint();
            FileInfoBittorrentPanel.this.table.validateSelection();
        }
    }

    private final class SelectNone
    extends AbstractAction {
        private SelectNone(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            FileInfoBittorrentPanel.this.torrent.getLock().lock();
            try {
                if (!FileInfoBittorrentPanel.this.torrent.isFinished()) {
                    for (TorrentFileEntryWrapper wrapper : FileInfoBittorrentPanel.this.eventList) {
                        if (wrapper.getProgress() == 1.0f) continue;
                        wrapper.setPriority(0);
                    }
                }
            }
            finally {
                FileInfoBittorrentPanel.this.torrent.getLock().unlock();
            }
            FileInfoBittorrentPanel.this.table.repaint();
            FileInfoBittorrentPanel.this.table.validateSelection();
        }
    }

    private class PriorityRendererEditor
    extends JPanel
    implements TableCellRenderer,
    TableCellEditor {
        private final List<CellEditorListener> listenerList;
        @Resource
        private Icon lowestPriorityIcon;
        @Resource
        private Icon normalPriorityIcon;
        @Resource
        private Icon highestPriorityIcon;
        @Resource
        private Font textFont;
        @Resource
        private Color fontColor;
        private final JButton button;
        private TorrentFileEntryWrapper currentWrapper;

        public PriorityRendererEditor() {
            super(new MigLayout("align 50%"));
            this.listenerList = new ArrayList<CellEditorListener>();
            GuiUtils.assignResources(this);
            this.button = new JButton();
            this.button.setBorderPainted(false);
            this.button.setContentAreaFilled(false);
            this.button.setFont(this.textFont);
            this.button.setFocusPainted(false);
            this.button.setForeground(this.fontColor);
            FontUtils.underline(this.button);
            this.add(this.button);
        }

        public JButton getButton() {
            return this.button;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.getTableCellComponent(table, value, isSelected, row, column);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.getTableCellComponent(table, value, isSelected, row, column);
        }

        private Component getTableCellComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof TorrentFileEntryWrapper) {
                this.currentWrapper = (TorrentFileEntryWrapper)value;
                int priority = ((TorrentFileEntryWrapper)value).getPriority();
                if (((TorrentFileEntryWrapper)value).getProgress() == 1.0f) {
                    this.button.setIcon(null);
                    this.button.setText("");
                } else if (priority == 0) {
                    this.button.setIcon(null);
                    this.button.setText("");
                } else if (priority == 1) {
                    this.button.setIcon(this.lowestPriorityIcon);
                    this.button.setText("");
                } else if (priority == 2) {
                    this.button.setIcon(this.normalPriorityIcon);
                    this.button.setText("");
                } else if (priority == 3) {
                    this.button.setIcon(this.highestPriorityIcon);
                    this.button.setText("");
                }
            } else {
                this.currentWrapper = null;
                this.button.setIcon(null);
                this.button.setText("");
            }
            return this;
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            if (!this.listenerList.contains(l)) {
                this.listenerList.add(l);
            }
        }

        @Override
        public void cancelCellEditing() {
            ChangeEvent event = new ChangeEvent(this);
            int size = this.listenerList.size();
            for (int i = 0; i < size; ++i) {
                this.listenerList.get(i).editingCanceled(event);
            }
        }

        @Override
        public TorrentFileEntryWrapper getCellEditorValue() {
            return this.currentWrapper;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listenerList.remove(l);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.cancelCellEditing();
            return true;
        }
    }

    private class PercentRenderer
    extends DefaultLimeTableCellRenderer {
        private PercentRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            if (value instanceof TorrentFileEntryWrapper) {
                float percent = ((TorrentFileEntryWrapper)value).getProgress();
                if (FileInfoBittorrentPanel.this.torrent.isFinished()) {
                    if (percent == 1.0f && ((TorrentFileEntryWrapper)value).getPriority() > 0) {
                        this.setText(I18n.tr("Done"));
                    } else {
                        this.setText("");
                    }
                } else if (((TorrentFileEntryWrapper)value).getPriority() == 0) {
                    this.setText("");
                } else {
                    this.setText((int)(percent * 100.0f) + "%");
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private class CheckBoxRendererEditor
    extends JCheckBox
    implements TableCellRenderer,
    TableCellEditor {
        private final List<CellEditorListener> listenerList = new ArrayList<CellEditorListener>();
        private TorrentFileEntryWrapper currentWrapper;

        public CheckBoxRendererEditor() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.getTableCellComponent(table, value, isSelected, column, column);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.getTableCellComponent(table, value, isSelected, column, column);
        }

        private Component getTableCellComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof TorrentFileEntryWrapper) {
                this.currentWrapper = (TorrentFileEntryWrapper)value;
                if (FileInfoBittorrentPanel.this.torrent.isFinished()) {
                    this.setEnabled(false);
                    this.setSelected(this.currentWrapper.getProgress() == 1.0f && this.currentWrapper.getPriority() > 0);
                } else if (this.currentWrapper.getProgress() == 1.0f) {
                    this.setSelected(true);
                    this.setEnabled(false);
                } else {
                    this.setSelected(((TorrentFileEntryWrapper)value).getPriority() != 0);
                    this.setEnabled(!FileInfoBittorrentPanel.this.torrent.isFinished());
                }
            } else {
                this.currentWrapper = null;
                this.setSelected(false);
            }
            return this;
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            if (!this.listenerList.contains(l)) {
                this.listenerList.add(l);
            }
        }

        @Override
        public void cancelCellEditing() {
            ChangeEvent event = new ChangeEvent(this);
            int size = this.listenerList.size();
            for (int i = 0; i < size; ++i) {
                this.listenerList.get(i).editingCanceled(event);
            }
        }

        @Override
        public TorrentFileEntryWrapper getCellEditorValue() {
            return this.currentWrapper;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listenerList.remove(l);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.cancelCellEditing();
            return true;
        }
    }

    private class NameComparator
    implements Comparator<String> {
        private NameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }

    private class PriorityComparator
    implements Comparator<TorrentFileEntryWrapper> {
        private PriorityComparator() {
        }

        @Override
        public int compare(TorrentFileEntryWrapper o1, TorrentFileEntryWrapper o2) {
            int o1Priority = this.getPriority(o1);
            int o2Priority = this.getPriority(o2);
            return o1Priority - o2Priority;
        }

        private int getPriority(TorrentFileEntryWrapper wrapper) {
            if (wrapper.getProgress() == 1.0f) {
                return 4;
            }
            return wrapper.getPriority();
        }
    }

    private class PercentComparator
    implements Comparator<TorrentFileEntryWrapper> {
        private PercentComparator() {
        }

        @Override
        public int compare(TorrentFileEntryWrapper o1, TorrentFileEntryWrapper o2) {
            int o1Percent = (int)o1.getProgress() * 100;
            int o2Percent = (int)o2.getProgress() * 100;
            if (o1.getPriority() == 0) {
                o1Percent = -1;
            }
            if (o2.getPriority() == 0) {
                o2Percent = -1;
            }
            return o1Percent - o2Percent;
        }
    }

    private class SelectedComparator
    implements Comparator<TorrentFileEntryWrapper> {
        private SelectedComparator() {
        }

        @Override
        public int compare(TorrentFileEntryWrapper o1, TorrentFileEntryWrapper o2) {
            boolean o1isSelected = this.getIsSelected(o1);
            boolean o2isSelected = this.getIsSelected(o2);
            if (o1isSelected && o2isSelected) {
                return 0;
            }
            if (o1isSelected) {
                return 1;
            }
            return -1;
        }

        private boolean getIsSelected(TorrentFileEntryWrapper wrapper) {
            if (FileInfoBittorrentPanel.this.torrent.isFinished()) {
                return wrapper.getProgress() == 1.0f && wrapper.getPriority() > 0;
            }
            if (wrapper.getProgress() == 1.0f) {
                return true;
            }
            return wrapper.getPriority() != 0;
        }
    }

    private class BitTorrentTableFormat
    extends AbstractTableFormat<TorrentFileEntryWrapper>
    implements EventListTableSortFormat,
    AdvancedTableFormat<TorrentFileEntryWrapper> {
        private static final int DOWNLOAD_INDEX = 0;
        private static final int NAME_INDEX = 1;
        private static final int SIZE_INDEX = 2;
        private static final int PERCENT_INDEX = 3;
        private static final int PRIORITY_INDEX = 4;

        public BitTorrentTableFormat() {
            super(I18n.tr("DL"), I18n.tr("Name"), I18n.tr("Size"), I18n.tr("%"), I18n.tr("Priority"));
        }

        @Override
        public Object getColumnValue(TorrentFileEntryWrapper baseObject, int column) {
            switch (column) {
                case 0: {
                    return baseObject;
                }
                case 1: {
                    return baseObject.getPath();
                }
                case 2: {
                    return baseObject.getSize();
                }
                case 3: {
                    return baseObject;
                }
                case 4: {
                    return baseObject;
                }
            }
            throw new IllegalStateException("Unknown column:" + column);
        }

        @Override
        public Comparator getColumnComparator(int column) {
            switch (column) {
                case 0: {
                    return new SelectedComparator();
                }
                case 1: {
                    return new NameComparator();
                }
                case 2: {
                    return Objects.getComparator(true);
                }
                case 3: {
                    return new PercentComparator();
                }
                case 4: {
                    return new PriorityComparator();
                }
            }
            throw new IllegalStateException("Unknown column:" + column);
        }

        @Override
        public List<SortKey> getDefaultSortKeys() {
            return Collections.emptyList();
        }

        @Override
        public List<SortKey> getPreSortColumns() {
            return Collections.emptyList();
        }

        @Override
        public List<Integer> getSecondarySortColumns(int column) {
            return Collections.emptyList();
        }

        @Override
        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return TorrentFileEntryWrapper.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Long.class;
                }
                case 3: {
                    return TorrentFileEntryWrapper.class;
                }
                case 4: {
                    return TorrentFileEntryWrapper.class;
                }
            }
            throw new IllegalStateException("Unknown column:" + column);
        }
    }

    private class BitTorrentTable
    extends MouseableTable {
        boolean torrentPartSelected;

        public BitTorrentTable(DefaultEventTableModel<TorrentFileEntryWrapper> model) {
            super(model);
            this.torrentPartSelected = true;
            this.setShowHorizontalLines(false);
            this.setSelectionMode(0);
            this.setColumnSelectionAllowed(false);
            final CheckBoxRendererEditor checkBoxEditor = new CheckBoxRendererEditor();
            checkBoxEditor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (checkBoxEditor.getCellEditorValue() != null) {
                        checkBoxEditor.getCellEditorValue().setPriority(checkBoxEditor.isSelected() ? 1 : 0);
                        checkBoxEditor.cancelCellEditing();
                    }
                    BitTorrentTable.this.validateSelection();
                    BitTorrentTable.this.repaint();
                }
            });
            this.getColumn(0).setCellRenderer(new CheckBoxRendererEditor());
            this.getColumn(0).setCellEditor(checkBoxEditor);
            this.getColumn(2).setCellRenderer(new FileSizeRenderer());
            this.getColumn(3).setCellRenderer(new PercentRenderer());
            this.getColumn(1).setCellRenderer(new DefaultLimeTableCellRenderer());
            final PriorityRendererEditor editor = new PriorityRendererEditor();
            editor.getButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int oldPriority = editor.getCellEditorValue().getPriority();
                    if (oldPriority != 0) {
                        editor.getCellEditorValue().setPriority(oldPriority + 1 > 3 ? 1 : oldPriority + 1);
                        editor.cancelCellEditing();
                        BitTorrentTable.this.repaint();
                    }
                }
            });
            this.getColumn(4).setCellRenderer(new PriorityRendererEditor());
            this.getColumn(4).setCellEditor(editor);
            this.getColumnExt(0).setMaxWidth(30);
            this.getColumnExt(0).setMinWidth(30);
            this.getColumnExt(3).setMaxWidth(50);
            this.getColumnExt(3).setMinWidth(50);
            this.getColumnExt(4).setMaxWidth(60);
            this.getColumnExt(4).setMinWidth(60);
        }

        private void validateSelection() {
            if (this.isAnyTorrentPartSelected() != this.torrentPartSelected) {
                this.torrentPartSelected = !this.torrentPartSelected;
                FileInfoBittorrentPanel.this.support.firePropertyChange(FileInfoBittorrentPanel.TORRENT_FILE_ENTRY_SELECTED, !this.torrentPartSelected, this.torrentPartSelected);
            }
        }

        private boolean isAnyTorrentPartSelected() {
            DefaultEventTableModel model = (DefaultEventTableModel)this.getModel();
            for (int counter = 0; counter < model.getRowCount(); ++counter) {
                TorrentFileEntryWrapper torrentFile = (TorrentFileEntryWrapper)model.getElementAt(counter);
                if (torrentFile.getPriority() == 0) continue;
                return true;
            }
            return false;
        }
    }
}

