/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.player;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.limewire.player.api.PlayerState;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.HeaderBar;
import org.limewire.ui.swing.components.decorators.HeaderBarDecorator;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.painter.ButtonBackgroundPainter;
import org.limewire.ui.swing.painter.factories.ButtonPainterFactory;
import org.limewire.ui.swing.player.PlayerControlPanel;
import org.limewire.ui.swing.player.PlayerControlPanelFactory;
import org.limewire.ui.swing.player.VideoPlayerMediator;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.SwingHacks;
import org.limewire.util.OSUtils;

class VideoPanel
implements Disposable {
    private final HeaderBar headerBar = new HeaderBar();
    private final JXCollapsiblePane headerBarCollapsiblePane = new JXCollapsiblePane();
    private ActionListener collapsingActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            VideoPanel.this.headerBarCollapsiblePane.setCollapsed(true);
        }
    };
    private Timer collapsePlayerControlsTimer = new Timer(2000, this.collapsingActionListener);
    @Resource
    private Icon fullScreenSelected;
    @Resource
    private Icon fullScreenUnselected;
    @Resource
    private Icon close;
    private final VideoPlayerMediator videoMediator;
    private final Container videoRenderer;
    private final JPanel videoPanel = new JPanel(new BorderLayout());
    private JXButton fullScreenButton;
    private final PlayerControlPanel controlPanel;
    private final MigLayout fitToScreenLayout = new MigLayout("align 50% 50%, novisualpadding, gap 0, ins 0");
    private final JPanel fitToScreenContainer = new JPanel(this.fitToScreenLayout);

    @Inject
    public VideoPanel(@Assisted Container videoRenderer, PlayerControlPanelFactory controlPanelFactory, HeaderBarDecorator headerBarDecorator, VideoPlayerMediator videoMediator, ButtonPainterFactory buttonPainterFactory) {
        this.videoRenderer = videoRenderer;
        this.videoMediator = videoMediator;
        GuiUtils.assignResources(this);
        this.controlPanel = controlPanelFactory.createVideoControlPanel();
        this.setUpHeaderBar(this.controlPanel, headerBarDecorator, buttonPainterFactory);
        this.setupActionMaps();
        this.videoPanel.setBackground(Color.BLACK);
        this.videoRenderer.setBackground(Color.BLACK);
        this.fitToScreenContainer.setBackground(Color.BLACK);
        this.setUpMouseListener(this.videoPanel);
        this.setUpMouseListener(this.fitToScreenContainer);
        this.setUpMouseListener(videoRenderer);
        videoRenderer.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                VideoPanel.this.setUpMouseListener(e.getChild());
                VideoPanel.this.setFitToScreen(SwingUiSettings.VIDEO_FIT_TO_SCREEN.getValue());
            }
        });
        this.fitToScreenContainer.add(this.videoRenderer);
        this.setFitToScreen(SwingUiSettings.VIDEO_FIT_TO_SCREEN.getValue());
        this.collapsePlayerControlsTimer.setRepeats(false);
        this.headerBarCollapsiblePane.setContentPane(this.headerBar);
        this.videoPanel.add((Component)this.headerBarCollapsiblePane, "North");
        this.videoPanel.add((Component)this.fitToScreenContainer, "Center");
    }

    public JComponent getComponent() {
        return this.videoPanel;
    }

    @Override
    public void dispose() {
        this.collapsePlayerControlsTimer.removeActionListener(this.collapsingActionListener);
        this.collapsingActionListener = null;
        this.collapsePlayerControlsTimer = null;
        this.controlPanel.dispose();
    }

    public void requestFocus() {
        this.headerBar.requestFocusInWindow();
    }

    public void playerLoaded() {
        this.headerBar.requestFocusInWindow();
        if (this.videoMediator.isFullScreen()) {
            this.setFitToScreen(true);
            this.fullScreenButton.setIcon(this.fullScreenSelected);
            if (!OSUtils.isMacOSX()) {
                this.collapsePlayerControlsTimer.restart();
            }
        } else {
            this.setFitToScreen(SwingUiSettings.VIDEO_FIT_TO_SCREEN.getValue());
            this.fullScreenButton.setIcon(this.fullScreenUnselected);
        }
    }

    private void setupActionMaps() {
        this.videoPanel.getInputMap(2).put(KeyStroke.getKeyStroke(70, 2), "fullScreen");
        this.videoPanel.getInputMap(2).put(KeyStroke.getKeyStroke(122, 0), "fullScreen");
        this.videoPanel.getActionMap().put("fullScreen", new ToggleFullScreen());
        this.videoPanel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "esc");
        this.videoPanel.getActionMap().put("esc", new EscAction());
        this.videoPanel.getInputMap(2).put(KeyStroke.getKeyStroke(32, 0), "space");
        this.videoPanel.getActionMap().put("space", new PlayOrPauseAction());
    }

    private void setUpMouseListener(Component videoComponent) {
        VideoPanelMouseListener listener = new VideoPanelMouseListener();
        videoComponent.addMouseListener(listener);
        videoComponent.addMouseMotionListener(listener);
    }

    private void setUpHeaderBar(JComponent controlPanel, HeaderBarDecorator headerBarDecorator, ButtonPainterFactory buttonPainterFactory) {
        this.headerBar.setFocusable(true);
        this.fullScreenButton = new JXButton(this.fullScreenUnselected);
        this.fullScreenButton.setContentAreaFilled(false);
        this.fullScreenButton.setFocusPainted(false);
        this.fullScreenButton.setBackgroundPainter(buttonPainterFactory.createDarkFullButtonBackgroundPainter(ButtonBackgroundPainter.DrawMode.FULLY_ROUNDED, BorderPainter.AccentType.SHADOW));
        this.fullScreenButton.addActionListener(new FullScreenListener());
        JXButton closeButton = new JXButton(this.close);
        closeButton.setContentAreaFilled(false);
        closeButton.setFocusPainted(false);
        closeButton.setBackgroundPainter(buttonPainterFactory.createDarkFullButtonBackgroundPainter(ButtonBackgroundPainter.DrawMode.FULLY_ROUNDED, BorderPainter.AccentType.SHADOW));
        closeButton.addActionListener(new CloseAction());
        headerBarDecorator.decorateBasic(this.headerBar);
        this.headerBar.setLayout(new MigLayout());
        this.headerBar.add((Component)this.fullScreenButton, "right, push");
        this.headerBar.add((Component)controlPanel, "pos 0.5al 0.5al");
        this.headerBar.add(closeButton);
    }

    private JMenuItem createFullScreenMenuItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(I18n.tr("Full Screen"));
        item.setSelected(this.videoMediator.isFullScreen());
        item.addActionListener(new FullScreenListener());
        return item;
    }

    private JMenuItem createPlayMenuItem() {
        JMenuItem item = new JMenuItem(I18n.tr("Play"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoPanel.this.videoMediator.resume();
            }
        });
        return item;
    }

    private JMenuItem createFitToScreenMenuItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(I18n.tr("Fit to Screen"));
        item.setSelected(SwingUiSettings.VIDEO_FIT_TO_SCREEN.getValue());
        item.addItemListener(new FitToScreenListener());
        return item;
    }

    private void setFitToScreen(boolean isFitToScreen) {
        if (isFitToScreen) {
            this.fitToScreenLayout.setComponentConstraints(this.videoRenderer, "grow, push");
            this.videoRenderer.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.videoRenderer.setMinimumSize(new Dimension(0, 0));
        } else {
            this.fitToScreenLayout.setComponentConstraints(this.videoRenderer, "");
            this.videoRenderer.setMaximumSize(this.videoRenderer.getPreferredSize());
            this.videoRenderer.setMinimumSize(new Dimension(0, 0));
        }
        this.fitToScreenContainer.revalidate();
    }

    private JMenuItem createPauseMenuItem() {
        JMenuItem item = new JMenuItem(I18n.tr("Pause"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoPanel.this.videoMediator.pause();
            }
        });
        return item;
    }

    private JMenuItem createCloseItem() {
        JMenuItem item = new JMenuItem(I18n.tr("Close Video"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoPanel.this.videoMediator.closeVideo();
            }
        });
        return item;
    }

    private class VideoPanelMouseListener
    extends MouseAdapter {
        private int mouseX;
        private int mouseY;

        private VideoPanelMouseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (VideoPanel.this.videoMediator.isFullScreen() && (e.getLocationOnScreen().x != this.mouseX || e.getLocationOnScreen().y != this.mouseY)) {
                VideoPanel.this.headerBarCollapsiblePane.setCollapsed(false);
                if (!OSUtils.isMacOSX()) {
                    VideoPanel.this.collapsePlayerControlsTimer.restart();
                }
                this.mouseX = e.getLocationOnScreen().x;
                this.mouseY = e.getLocationOnScreen().y;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JPopupMenu menu = new JPopupMenu();
                SwingHacks.fixPopupMenuForWindows(menu);
                if (VideoPanel.this.videoMediator.getStatus() == PlayerState.PLAYING) {
                    menu.add(VideoPanel.this.createPauseMenuItem());
                } else {
                    menu.add(VideoPanel.this.createPlayMenuItem());
                }
                menu.addSeparator();
                if (!VideoPanel.this.videoMediator.isFullScreen()) {
                    menu.add(VideoPanel.this.createFitToScreenMenuItem());
                }
                menu.add(VideoPanel.this.createFullScreenMenuItem());
                menu.addSeparator();
                menu.add(VideoPanel.this.createCloseItem());
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class PlayOrPauseAction
    extends AbstractAction {
        private PlayOrPauseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (VideoPanel.this.videoMediator.getStatus() == PlayerState.PLAYING) {
                VideoPanel.this.videoMediator.pause();
            } else {
                VideoPanel.this.videoMediator.resume();
            }
        }
    }

    private class EscAction
    extends AbstractAction {
        private EscAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (VideoPanel.this.videoMediator.isFullScreen()) {
                VideoPanel.this.videoMediator.setFullScreen(false);
            } else {
                VideoPanel.this.videoMediator.closeVideo();
            }
        }
    }

    private class FitToScreenListener
    implements ItemListener {
        private FitToScreenListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            VideoPanel.this.setFitToScreen(e.getStateChange() == 1);
            SwingUiSettings.VIDEO_FIT_TO_SCREEN.setValue(e.getStateChange() == 1);
        }
    }

    private class ToggleFullScreen
    extends AbstractAction {
        private ToggleFullScreen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VideoPanel.this.videoMediator.setFullScreen(!VideoPanel.this.videoMediator.isFullScreen());
        }
    }

    private class FullScreenListener
    implements ActionListener {
        private FullScreenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VideoPanel.this.videoMediator.setFullScreen(!VideoPanel.this.videoMediator.isFullScreen());
        }
    }

    private class CloseAction
    extends AbstractAction {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VideoPanel.this.videoMediator.closeVideo();
        }
    }
}

