/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.painter.factories;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Paint;
import javax.swing.JTextField;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.Painter;
import org.limewire.ui.swing.components.PromptTextField;
import org.limewire.ui.swing.painter.BasicTextFieldPromptPainter;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.painter.ComponentBackgroundPainter;
import org.limewire.ui.swing.painter.FilterPainter;
import org.limewire.ui.swing.util.GuiUtils;

public class TextFieldPainterFactory {
    @Resource
    private Color promptForeground;
    @Resource
    private int arcWidth;
    @Resource
    private int arcHeight;
    @Resource
    private Color border;
    @Resource
    private Color bevelLeft;
    @Resource
    private Color bevelTop1;
    @Resource
    private Color bevelTop2;
    @Resource
    private Color bevelRight;
    @Resource
    private Color bevelBottom;

    @Inject
    TextFieldPainterFactory() {
        GuiUtils.assignResources(this);
    }

    public AbstractPainter<JTextField> createBasicBackgroundPainter(BorderPainter.AccentType accentType) {
        return new ComponentBackgroundPainter<JTextField>(Color.WHITE, this.border, this.bevelLeft, this.bevelTop1, this.bevelTop2, this.bevelRight, this.bevelBottom, this.arcWidth, this.arcHeight, accentType);
    }

    public AbstractPainter<JTextField> createBasicBackgroundPainter(BorderPainter.AccentType accentType, Paint border) {
        return new ComponentBackgroundPainter<JTextField>(Color.WHITE, border, this.bevelLeft, this.bevelTop1, this.bevelTop2, this.bevelRight, this.bevelBottom, this.arcWidth, this.arcHeight, accentType);
    }

    public Painter<JTextField> createClearableBackgroundPainter(PromptTextField textField, BorderPainter.AccentType accentType) {
        FilterPainter filterPainter = new FilterPainter(this.arcWidth, this.arcHeight);
        filterPainter.install(textField);
        CompoundPainter<JTextField> painter = new CompoundPainter<JTextField>();
        painter.setPainters(filterPainter, this.createBorderPainter(accentType));
        painter.setCacheable(true);
        return painter;
    }

    public BasicTextFieldPromptPainter<JTextField> createBasicPromptPainter() {
        return new BasicTextFieldPromptPainter<JTextField>(this.promptForeground);
    }

    private BorderPainter<JTextField> createBorderPainter(BorderPainter.AccentType accentType) {
        return new BorderPainter<JTextField>(this.arcWidth, this.arcHeight, this.border, this.bevelLeft, this.bevelTop1, this.bevelTop2, this.bevelRight, this.bevelBottom, accentType);
    }
}

