/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.painter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.limewire.ui.swing.util.PainterUtils;

public class TextShadowPainter<X extends Component>
extends AbstractPainter<X> {
    private static final Paint DEFAULT_SHADOW = new Color(0, 0, 0, 150);
    private Insets insets = PainterUtils.BLANK_INSETS;
    private final Paint shadow;

    public TextShadowPainter(Paint shadow, Insets insets, boolean cached) {
        this.setAntialiasing(true);
        this.setCacheable(cached);
        this.shadow = shadow;
        this.setInsets(insets);
    }

    public TextShadowPainter() {
        this.setAntialiasing(true);
        this.setCacheable(true);
        this.shadow = DEFAULT_SHADOW;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    @Override
    protected void doPaint(Graphics2D g, X object, int width, int height) {
        String label = TextShadowPainter.getText(object);
        g.setFont(((Component)object).getFont());
        int h = g.getFontMetrics().getAscent();
        g.setPaint(this.shadow);
        g.drawString(label, this.insets.left + 1, this.insets.top + height / 2 + h / 2 - 1);
        g.setColor(((Component)object).getForeground());
        g.drawString(label, this.insets.left + 0, this.insets.top + height / 2 + h / 2 - 2);
    }

    private static String getText(Component object) {
        try {
            Method method = object.getClass().getMethod("getText", new Class[0]);
            return method.invoke((Object)object, new Object[0]).toString();
        }
        catch (NoSuchMethodException e) {
            return "";
        }
        catch (InvocationTargetException e) {
            return "";
        }
        catch (IllegalAccessException e) {
            return "";
        }
    }
}

