/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.limewire.core.api.spam.SpamManager;
import org.limewire.core.settings.FilterSettings;
import org.limewire.io.IP;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.components.TextFieldClipboardControl;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.FontUtils;
import org.limewire.ui.swing.util.I18n;

public class FilteringOptionPanel
extends OptionPanel {
    private SpamManager spamManager;
    private BlockHostsPanel blockHostPanel;
    private AllowHostsPanel allowHostsPanel;

    @Inject
    public FilteringOptionPanel(SpamManager spamManager) {
        this.spamManager = spamManager;
        this.setLayout(new MigLayout("insets 15, fillx, wrap"));
        this.setOpaque(false);
        this.add((Component)this.getBlockHostsPanel(), "pushx, growx");
        this.add((Component)this.getAllowHostsPanel(), "pushx, growx");
    }

    private OptionPanel getBlockHostsPanel() {
        if (this.blockHostPanel == null) {
            this.blockHostPanel = new BlockHostsPanel();
        }
        return this.blockHostPanel;
    }

    private OptionPanel getAllowHostsPanel() {
        if (this.allowHostsPanel == null) {
            this.allowHostsPanel = new AllowHostsPanel();
        }
        return this.allowHostsPanel;
    }

    @Override
    boolean applyOptions() {
        boolean restart = this.getBlockHostsPanel().applyOptions();
        return restart |= this.getAllowHostsPanel().applyOptions();
    }

    @Override
    boolean hasChanged() {
        return this.getBlockHostsPanel().hasChanged() || this.getAllowHostsPanel().hasChanged();
    }

    @Override
    public void initOptions() {
        this.getBlockHostsPanel().initOptions();
        this.getAllowHostsPanel().initOptions();
    }

    public static class AddAction
    implements ActionListener {
        private JTextField textField;
        private FilteringTable table;

        public AddAction(JTextField textField, FilteringTable table) {
            this.table = table;
            this.textField = textField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.textField.getText() != null && this.textField.getText().length() > 0) {
                try {
                    new IP(this.textField.getText());
                    this.table.addIp(this.textField.getText());
                    this.table.invalidate();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                this.textField.setText("");
            }
        }
    }

    private class FilterModel
    extends AbstractTableModel {
        private List<String> filters;

        public FilterModel(List<String> filters) {
            this.filters = filters;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.filters.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.filters.get(rowIndex);
        }

        public List<String> getModel() {
            return this.filters;
        }

        public void addIP(String ip) {
            if (!this.filters.contains(ip)) {
                this.filters.add(ip);
            }
            FilteringOptionPanel.this.repaint();
        }

        public void removeIP(int index) {
            if (index < 0 || index >= this.filters.size()) {
                return;
            }
            this.filters.remove(index);
        }
    }

    private class RemoveButtonRenderer
    extends JButton
    implements TableCellRenderer,
    TableCellEditor {
        private final List<CellEditorListener> listeners;

        public RemoveButtonRenderer(final FilteringTable table) {
            super(I18n.tr("remove"));
            this.listeners = new ArrayList<CellEditorListener>();
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setContentAreaFilled(false);
            FontUtils.underline(this);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    table.getFilterModel().removeIP(table.getSelectedRow());
                    RemoveButtonRenderer.this.cancelCellEditing();
                    table.repaint();
                }
            });
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelCellEditing() {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                int N = this.listeners.size();
                for (int i = 0; i < N; ++i) {
                    this.listeners.get(i).editingCanceled(new ChangeEvent(this));
                }
            }
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCellEditorListener(CellEditorListener lis) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                if (this.listeners.contains(lis)) {
                    this.listeners.remove(lis);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCellEditorListener(CellEditorListener lis) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                if (!this.listeners.contains(lis)) {
                    this.listeners.add(lis);
                }
            }
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.cancelCellEditing();
            return true;
        }
    }

    private class FilteringTable
    extends JXTable {
        private FilterModel model;

        public FilteringTable() {
            this.setTableHeader(null);
            this.setShowGrid(false);
            this.setSelectionMode(0);
            this.setSelectionBackground(this.getBackground());
            this.setSelectionForeground(this.getForeground());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TableCellEditor editor;
                    int col = FilteringTable.this.columnAtPoint(e.getPoint());
                    int row = FilteringTable.this.rowAtPoint(e.getPoint());
                    if (row >= 0 && col >= 0 && (editor = FilteringTable.this.getCellEditor()) != null) {
                        FilteringTable.this.prepareEditor(editor, row, col);
                        FilteringTable.this.repaint();
                    }
                }
            });
        }

        public void setModel(FilterModel model) {
            super.setModel(model);
            this.model = model;
            this.getColumn(1).setCellRenderer(new RemoveButtonRenderer(this));
            this.getColumn(1).setCellEditor(new RemoveButtonRenderer(this));
        }

        public FilterModel getFilterModel() {
            return this.model;
        }

        public void addIp(String ip) {
            if (this.model != null) {
                this.model.addIP(ip);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (row >= this.getRowCount() || col >= this.getColumnCount() || row < 0 || col < 0) {
                return false;
            }
            return this.getColumnModel().getColumn(col).getCellEditor() != null;
        }
    }

    private class AllowHostsPanel
    extends OptionPanel {
        private JTextField addressTextField;
        private JButton addButton;
        private FilteringTable filterTable;
        private final String description;

        public AllowHostsPanel() {
            super(I18n.tr("Allow Hosts"));
            this.description = I18n.tr("Override the block list and allow specific people by adding their IP address");
            this.setLayout(new MigLayout("gapy 10", "[sg 1][sg 1][]", ""));
            this.addressTextField = new JTextField(26);
            TextFieldClipboardControl.install(this.addressTextField);
            this.addButton = new JButton(I18n.tr("Add Address"));
            this.filterTable = new FilteringTable();
            this.addButton.addActionListener(new AddAction(this.addressTextField, this.filterTable));
            this.add((Component)new MultiLineLabel(this.description, 440), "span, growx, wrap");
            this.add((Component)this.addressTextField, "gapright 10");
            this.add((Component)this.addButton, "wrap");
            this.add((Component)new JScrollPane(this.filterTable), "growx, span 2");
        }

        @Override
        boolean applyOptions() {
            List<String> list = this.filterTable.getFilterModel().getModel();
            FilterSettings.WHITE_LISTED_IP_ADDRESSES.set(list.toArray(new String[list.size()]));
            BackgroundExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    FilteringOptionPanel.this.spamManager.reloadIPFilter();
                }
            });
            return false;
        }

        @Override
        boolean hasChanged() {
            List<String> model = Arrays.asList(FilterSettings.WHITE_LISTED_IP_ADDRESSES.get());
            return !((Object)model).equals(this.filterTable.getFilterModel().getModel());
        }

        @Override
        public void initOptions() {
            String[] allowedIps = FilterSettings.WHITE_LISTED_IP_ADDRESSES.get();
            FilterModel model = new FilterModel(new ArrayList<String>(Arrays.asList(allowedIps)));
            this.filterTable.setModel(model);
        }
    }

    private class BlockHostsPanel
    extends OptionPanel {
        private JTextField addressTextField;
        private JButton addButton;
        private FilteringTable filterTable;
        private JCheckBox backListCheckBox;
        private String description;

        public BlockHostsPanel() {
            super(I18n.tr("Block Hosts"));
            this.description = I18n.tr("Use LimeWire's blacklist to protect you from harmful people");
            this.setLayout(new MigLayout("gapy 10", "[sg 1][sg 1][]", ""));
            this.addressTextField = new JTextField(26);
            TextFieldClipboardControl.install(this.addressTextField);
            this.addButton = new JButton(I18n.tr("Add Address"));
            this.filterTable = new FilteringTable();
            this.backListCheckBox = new JCheckBox();
            this.backListCheckBox.setOpaque(false);
            this.addButton.addActionListener(new AddAction(this.addressTextField, this.filterTable));
            this.add((Component)new JLabel("<html>" + I18n.tr("Block contact with specific people by adding their IP address") + "</html>"), "span, growx, wrap");
            this.add((Component)this.addressTextField, "gapright 10");
            this.add((Component)this.addButton, "wrap");
            this.add((Component)new JScrollPane(this.filterTable), "growx, span 2, wrap");
            this.add((Component)this.backListCheckBox, "span, split");
            this.add((Component)new MultiLineLabel(this.description, 440), "span, growx");
        }

        @Override
        boolean applyOptions() {
            List<String> list = this.filterTable.getFilterModel().getModel();
            FilterSettings.USE_NETWORK_FILTER.setValue(this.backListCheckBox.isSelected());
            FilterSettings.BLACK_LISTED_IP_ADDRESSES.set(list.toArray(new String[list.size()]));
            BackgroundExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    FilteringOptionPanel.this.spamManager.reloadIPFilter();
                }
            });
            return false;
        }

        @Override
        boolean hasChanged() {
            List<String> model = Arrays.asList(FilterSettings.BLACK_LISTED_IP_ADDRESSES.get());
            return this.backListCheckBox.isSelected() != FilterSettings.USE_NETWORK_FILTER.getValue() || !((Object)model).equals(this.filterTable.getFilterModel().getModel());
        }

        @Override
        public void initOptions() {
            String[] bannedIps = FilterSettings.BLACK_LISTED_IP_ADDRESSES.get();
            FilterModel model = new FilterModel(new ArrayList<String>(Arrays.asList(bannedIps)));
            this.filterTable.setModel(model);
            this.backListCheckBox.setSelected(FilterSettings.USE_NETWORK_FILTER.getValue());
        }
    }
}

