/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.nav;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.limewire.ui.swing.nav.NavItem;
import org.limewire.ui.swing.nav.NavItemListener;

public class NavigatorUtils {
    public static final String NAV_ITEM = "limewire.navigator.NAV_ITEM";

    private NavigatorUtils() {
    }

    public static Action getNavAction(final NavItem item) {
        return new AbstractAction(){
            {
                item.addNavItemListener(new NavItemListener(){

                    @Override
                    public void itemRemoved(boolean wasSelected) {
                    }

                    @Override
                    public void itemSelected(boolean selected) {
                        this.putValue("SwingSelectedKey", selected);
                    }
                });
                this.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("SwingSelectedKey") && evt.getNewValue().equals(Boolean.TRUE)) {
                            item.select();
                        }
                    }
                });
                this.putValue(NavigatorUtils.NAV_ITEM, item);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                item.select();
            }
        };
    }
}

