/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.menu;

import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.swing.JMenu;
import javax.swing.event.MenuListener;
import org.limewire.ui.swing.action.DelayedMenuItemCreator;
import org.limewire.ui.swing.action.MnemonicMenu;
import org.limewire.ui.swing.menu.ActivationAction;
import org.limewire.ui.swing.menu.AddFileAction;
import org.limewire.ui.swing.menu.ExitAction;
import org.limewire.ui.swing.menu.ExitAfterTransferAction;
import org.limewire.ui.swing.menu.FixStalledDownloadsAction;
import org.limewire.ui.swing.menu.OpenFileAction;
import org.limewire.ui.swing.menu.OpenLinkAction;
import org.limewire.ui.swing.menu.RecentDownloadsMenu;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.OSUtils;

class FileMenu
extends MnemonicMenu
implements DelayedMenuItemCreator {
    private final JMenu recentDownloadsMenu;
    private Provider<ActivationAction> activationActionProvider;
    private Provider<OpenFileAction> openFileActionProvider;
    private Provider<OpenLinkAction> openLinkActionProvider;
    private Provider<AddFileAction> addFileActionProvider;
    private Provider<FixStalledDownloadsAction> fixStalledDownloadsActionProvider;
    private Provider<ExitAfterTransferAction> exitAfterTransferActionProvider;
    private Provider<ExitAction> exitActionProvider;

    @Inject
    public FileMenu(RecentDownloadsMenu recentDownloadsMenu, Provider<ActivationAction> activationActionProvider, Provider<OpenFileAction> openFileActionProvider, Provider<OpenLinkAction> openLinkActionProvider, Provider<AddFileAction> addFileActionProvider, Provider<FixStalledDownloadsAction> fixStalledDownloadsActionProvider, Provider<ExitAfterTransferAction> exitAfterTransferActionProvider, Provider<ExitAction> exitActionProvider) {
        super(I18n.tr("&File"));
        this.recentDownloadsMenu = recentDownloadsMenu;
        this.activationActionProvider = activationActionProvider;
        this.openFileActionProvider = openFileActionProvider;
        this.openLinkActionProvider = openLinkActionProvider;
        this.addFileActionProvider = addFileActionProvider;
        this.fixStalledDownloadsActionProvider = fixStalledDownloadsActionProvider;
        this.exitAfterTransferActionProvider = exitAfterTransferActionProvider;
        this.exitActionProvider = exitActionProvider;
    }

    @Override
    public void createMenuItems() {
        this.add(this.activationActionProvider.get());
        this.add(this.openFileActionProvider.get());
        this.add(this.openLinkActionProvider.get());
        this.add(this.recentDownloadsMenu);
        this.addSeparator();
        this.add(this.addFileActionProvider.get());
        this.addSeparator();
        this.add(this.fixStalledDownloadsActionProvider.get());
        if (!OSUtils.isMacOSX()) {
            this.addSeparator();
            this.add(this.exitAfterTransferActionProvider.get());
            this.add(this.exitActionProvider.get());
        }
    }

    @Override
    public void addMenuListener(MenuListener listener) {
        super.addMenuListener(listener);
        this.recentDownloadsMenu.addMenuListener(listener);
    }
}

