/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.mainframe;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.limewire.core.api.Application;
import org.limewire.inject.EagerSingleton;
import org.limewire.ui.swing.browser.BrowserUtils;
import org.limewire.ui.swing.browser.UriAction;
import org.limewire.ui.swing.mainframe.StorePanel;
import org.limewire.ui.swing.nav.NavCategory;
import org.limewire.ui.swing.nav.NavMediator;
import org.limewire.ui.swing.nav.Navigator;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.NativeLaunchUtils;
import org.limewire.ui.swing.util.SwingUtils;
import org.mozilla.browser.MozillaInitialization;

@EagerSingleton
public class StoreMediator
implements NavMediator<StorePanel> {
    public static final String NAME = "LimeWire Store";
    private Provider<StorePanel> store;
    private StorePanel storePanel;
    private Navigator navigator;
    private Application application;

    @Inject
    public StoreMediator(Provider<StorePanel> storePanel, Navigator navigator, Application application) {
        this.store = storePanel;
        this.navigator = navigator;
        this.application = application;
        BrowserUtils.addTargetedUrlAction("_lwStore", new UriAction(){

            @Override
            public boolean uriClicked(final UriAction.TargetedUri targetedUrl) {
                SwingUtils.invokeNowOrLater(new Runnable(){

                    @Override
                    public void run() {
                        StoreMediator.this.load(targetedUrl.getUri());
                    }
                });
                return true;
            }
        });
    }

    @Override
    public StorePanel getComponent() {
        if (this.storePanel == null) {
            this.storePanel = this.store.get();
        }
        return this.storePanel;
    }

    public void load(String url) {
        if (StoreMediator.canShowStoreMenu()) {
            this.navigator.getNavItem(NavCategory.LIMEWIRE, NAME).select();
            this.getComponent().load(url);
        } else {
            NativeLaunchUtils.openURL(this.application.addClientInfoToUrl(url));
        }
    }

    public static boolean canShowStoreMenu() {
        return SwingUiSettings.SHOW_STORE_COMPONENTS.getValue() && MozillaInitialization.isInitialized();
    }
}

