/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.ui.swing.library.table.AbstractLibraryFormat;
import org.limewire.ui.swing.settings.TablesHandler;
import org.limewire.ui.swing.table.ColumnStateInfo;
import org.limewire.ui.swing.util.I18n;

public class VideoTableFormat<T extends LocalFileItem>
extends AbstractLibraryFormat<T> {
    static final int NAME_INDEX = 0;
    static final int TITLE_INDEX = 1;
    static final int LENGTH_INDEX = 2;
    static final int MISC_INDEX = 3;
    static final int YEAR_INDEX = 4;
    static final int SIZE_INDEX = 5;
    static final int RATING_INDEX = 6;
    static final int DIMENSION_INDEX = 7;
    static final int DESCRIPTION_INDEX = 8;
    static final int GENRE_INDEX = 9;
    static final int HIT_INDEX = 10;
    static final int UPLOADS_INDEX = 11;
    static final int UPLOAD_ATTEMPTS_INDEX = 12;
    static final int PATH_INDEX = 13;
    static final int ACTION_INDEX = 14;

    @Inject
    public VideoTableFormat() {
        super(14, "LIBRARY_VIDEO_TABLE", 0, true, new ColumnStateInfo(0, "LIBRARY_VIDEO_NAME", I18n.tr("Name"), 658, true, true), new ColumnStateInfo(1, "LIBRARY_VIDEO_TITLE", I18n.tr("Title"), 100, false, true), new ColumnStateInfo(2, "LIBRARY_VIDEO_LENGTH", I18n.tr("Length"), 52, true, true), new ColumnStateInfo(3, "LIBRARY_VIDEO_MISC", I18n.tr("Misc"), 100, false, true), new ColumnStateInfo(4, "LIBRARY_VIDEO_YEAR", I18n.tr("Year"), 80, false, true), new ColumnStateInfo(5, "LIBRARY_VIDEO_SIZE", I18n.tr("Size"), 60, false, true), new ColumnStateInfo(6, "LIBRARY_VIDEO_RATING", I18n.tr("Rating"), 60, false, true), new ColumnStateInfo(7, "LIBRARY_VIDEO_RESOLUTION", I18n.tr("Resolution"), 80, false, true), new ColumnStateInfo(8, "LIBRARY_VIDEO_DESCRIPTION", I18n.tr("Description"), 100, false, true), new ColumnStateInfo(9, "LIBRARY_VIDEO_GENRE", I18n.tr("Genre"), 80, false, true), new ColumnStateInfo(10, "LIBRARY_VIDEO_HITS", I18n.tr("Hits"), 100, false, true), new ColumnStateInfo(11, "LIBRARY_VIDEO_UPLOADS", I18n.tr("Uploads"), 100, false, true), new ColumnStateInfo(12, "LIBRARY_VIDEO_UPLOAD_ATTEMPTS", I18n.tr("Upload attempts"), 200, false, true), new ColumnStateInfo(13, "LIBRARY_VIDEO_PATH", I18n.tr("Location"), 200, false, true), new ColumnStateInfo(14, "LIBRARY_VIDEO_ACTION", I18n.tr(" "), 22, 22, true, false));
    }

    @Override
    public Object getColumnValue(T baseObject, int column) {
        switch (column) {
            case 0: {
                return baseObject;
            }
            case 1: {
                return baseObject.getProperty(FilePropertyKey.TITLE);
            }
            case 2: {
                return baseObject.getProperty(FilePropertyKey.LENGTH);
            }
            case 3: {
                return "";
            }
            case 4: {
                return baseObject.getProperty(FilePropertyKey.YEAR);
            }
            case 6: {
                return baseObject.getProperty(FilePropertyKey.RATING);
            }
            case 5: {
                return baseObject.getSize();
            }
            case 7: {
                if (baseObject.getProperty(FilePropertyKey.WIDTH) == null || baseObject.getProperty(FilePropertyKey.HEIGHT) == null) {
                    return null;
                }
                return baseObject.getProperty(FilePropertyKey.WIDTH) + " X " + baseObject.getProperty(FilePropertyKey.HEIGHT);
            }
            case 8: {
                return baseObject.getProperty(FilePropertyKey.DESCRIPTION);
            }
            case 9: {
                return baseObject.getProperty(FilePropertyKey.GENRE);
            }
            case 10: {
                return baseObject.getNumHits();
            }
            case 12: {
                return baseObject.getNumUploadAttempts();
            }
            case 11: {
                return baseObject.getNumUploads();
            }
            case 13: {
                return baseObject.getProperty(FilePropertyKey.LOCATION);
            }
            case 14: {
                return baseObject;
            }
        }
        throw new IllegalArgumentException("Unknown column:" + column);
    }

    @Override
    public List<SortKey> getDefaultSortKeys() {
        if (TablesHandler.getSortedColumn(this.getSortOrderID(), this.getSortedColumn()).getValue() == this.getSortedColumn() && TablesHandler.getSortedOrder(this.getSortOrderID(), this.getSortOrder()).getValue() == this.getSortOrder()) {
            return Arrays.asList(new SortKey(SortOrder.ASCENDING, 0), new SortKey(SortOrder.ASCENDING, 5));
        }
        return super.getDefaultSortKeys();
    }

    @Override
    public List<Integer> getSecondarySortColumns(int column) {
        switch (column) {
            case 0: {
                return Arrays.asList(5);
            }
            case 5: {
                return Arrays.asList(0);
            }
        }
        return Collections.emptyList();
    }
}

