/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import org.limewire.core.api.library.LibraryFileList;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.ui.swing.library.LibrarySelected;
import org.limewire.ui.swing.library.table.DeleteAction;
import org.limewire.ui.swing.library.table.LaunchFileAction;
import org.limewire.ui.swing.library.table.ListMenuFactory;
import org.limewire.ui.swing.library.table.LocateFileAction;
import org.limewire.ui.swing.library.table.RemoveFromListAction;
import org.limewire.ui.swing.library.table.RemoveFromListMenu;
import org.limewire.ui.swing.library.table.RenameFileAction;
import org.limewire.ui.swing.library.table.ViewFileInfoAction;

public class LibraryPopupMenu
extends JPopupMenu {
    private final Provider<List<File>> selectedFiles;
    private final Provider<LocalFileList> selectedLocalFileList;
    private final Provider<List<LocalFileItem>> selectedLocalFileItems;
    private final ListMenuFactory listMenuFactory;
    private final Provider<LaunchFileAction> launchAction;
    private final Provider<RenameFileAction> renameFileAction;
    private final Provider<LocateFileAction> locateAction;
    private final Provider<RemoveFromListMenu> removeFromListMenu;
    private final Provider<RemoveFromListAction> removeFromListAction;
    private final DeleteAction deleteAction;
    private final Provider<ViewFileInfoAction> fileInfoAction;

    @Inject
    public LibraryPopupMenu(@LibrarySelected Provider<List<File>> selectedFiles, @LibrarySelected Provider<LocalFileList> selectedLocalFileList, @LibrarySelected Provider<List<LocalFileItem>> selectedLocalFileItems, ListMenuFactory listMenuFactory, Provider<RemoveFromListMenu> removeFromListMenu, Provider<RemoveFromListAction> removeFromListAction, Provider<LaunchFileAction> launchAction, Provider<LocateFileAction> locateAction, Provider<RenameFileAction> renameFileAction, DeleteAction deleteAction, Provider<ViewFileInfoAction> fileInfoAction) {
        this.selectedFiles = selectedFiles;
        this.selectedLocalFileList = selectedLocalFileList;
        this.selectedLocalFileItems = selectedLocalFileItems;
        this.listMenuFactory = listMenuFactory;
        this.launchAction = launchAction;
        this.renameFileAction = renameFileAction;
        this.locateAction = locateAction;
        this.removeFromListMenu = removeFromListMenu;
        this.removeFromListAction = removeFromListAction;
        this.deleteAction = deleteAction;
        this.fileInfoAction = fileInfoAction;
        this.init();
    }

    private void init() {
        if (this.selectedLocalFileList.get() instanceof LibraryFileList) {
            this.initLibrary();
        } else {
            this.initPlayList();
        }
    }

    private void initLibrary() {
        ArrayList localFileItem = new ArrayList(this.selectedLocalFileItems.get());
        if (localFileItem.size() == 1) {
            this.add(this.launchAction.get());
            this.addSeparator();
            this.add(this.listMenuFactory.createAddToListMenu(this.selectedFiles));
            this.add(this.listMenuFactory.createShowInListMenu(this.selectedFiles, this.selectedLocalFileList, false));
            this.add(this.removeFromListMenu.get());
            this.addSeparator();
            this.add(this.renameFileAction.get()).setEnabled(!((LocalFileItem)localFileItem.get(0)).isIncomplete());
            this.add(this.locateAction.get());
            this.add(this.deleteAction);
            this.addSeparator();
            this.add(this.fileInfoAction.get());
        } else {
            this.add(this.listMenuFactory.createAddToListMenu(this.selectedFiles));
            this.add(this.removeFromListMenu.get());
            this.addSeparator();
            this.add(this.deleteAction);
        }
    }

    private void initPlayList() {
        ArrayList localFileItem = new ArrayList(this.selectedLocalFileItems.get());
        if (localFileItem.size() == 1) {
            this.add(this.launchAction.get());
            this.addSeparator();
            this.add(this.listMenuFactory.createShowInListMenu(this.selectedFiles, this.selectedLocalFileList, true));
            this.add(this.removeFromListAction.get());
            this.addSeparator();
            this.add(this.renameFileAction.get()).setEnabled(!((LocalFileItem)localFileItem.get(0)).isIncomplete());
            this.add(this.locateAction.get());
            this.add(this.deleteAction);
            this.addSeparator();
            this.add(this.fileInfoAction.get());
        } else {
            this.add(this.removeFromListAction.get());
            this.addSeparator();
            this.add(this.deleteAction);
        }
    }
}

