/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Provider;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.library.ShareListIcons;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.I18n;

class AddToListMenu
extends JMenu {
    private final Provider<List<File>> selectedFiles;
    private final ShareListIcons icons = new ShareListIcons();

    public AddToListMenu(Provider<List<File>> selectedFiles) {
        super(I18n.tr("Add to List"));
        this.selectedFiles = selectedFiles;
    }

    public void initialize(final SharedFileListManager manager) {
        this.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent e) {
                AddToListMenu menu = AddToListMenu.this;
                menu.removeAll();
                manager.getModel().getReadWriteLock().readLock().lock();
                try {
                    for (SharedFileList fileList : manager.getModel()) {
                        if (((List)AddToListMenu.this.selectedFiles.get()).size() == 1) {
                            menu.add(new AddListAction(fileList.getCollectionName(), AddToListMenu.this.icons.getListIcon(fileList), fileList));
                            continue;
                        }
                        menu.add(new AddListAction(fileList.getCollectionName(), AddToListMenu.this.icons.getListIcon(fileList), fileList));
                    }
                }
                finally {
                    manager.getModel().getReadWriteLock().readLock().unlock();
                }
            }
        });
        this.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (AddToListMenu.this.getPopupMenu().getPreferredSize().width > 300) {
                    AddToListMenu.this.getPopupMenu().setPreferredSize(new Dimension(300, AddToListMenu.this.getPopupMenu().getPreferredSize().height));
                }
            }
        });
        this.add(new JMenuItem(I18n.tr("empty")));
    }

    private class AddListAction
    extends AbstractAction {
        private final LocalFileList localFileList;

        public AddListAction(String text, Icon icon, LocalFileList localFileList) {
            super(text);
            this.putValue("SmallIcon", icon);
            this.localFileList = localFileList;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BackgroundExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    ArrayList selected = new ArrayList((Collection)AddToListMenu.this.selectedFiles.get());
                    for (File file : selected) {
                        AddListAction.this.localFileList.addFile(file);
                    }
                }
            });
        }
    }
}

