/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.sharing;

import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Resource;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.friend.api.FriendEvent;
import org.limewire.inject.LazySingleton;
import org.limewire.listener.EventBean;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.friends.login.AutoLoginService;
import org.limewire.ui.swing.library.sharing.LibrarySharingEditablePanel;
import org.limewire.ui.swing.library.sharing.LibrarySharingFriendListPanel;
import org.limewire.ui.swing.library.sharing.LibrarySharingLoginPanel;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;

@LazySingleton
public class LibrarySharingPanel {
    public static final String EDIT_MODE = "EDIT_MODE";
    @Resource
    private Color backgroundColor;
    @Resource
    private Color borderColor;
    private static final String LOGIN_VIEW = "LOGIN_VIEW";
    private static final String EDITABLE_VIEW = "EDITABLE_VIEW";
    private static final String FRIEND_LIST_VIEW = "FRIEND_LIST_VIEW";
    private final Provider<LibrarySharingLoginPanel> loginPanelProvider;
    private final Provider<LibrarySharingFriendListPanel> friendListPanelProvider;
    private final Provider<LibrarySharingEditablePanel> editablePanelProvider;
    private final Provider<AutoLoginService> autoLoginServiceProvider;
    private LibrarySharingLoginPanel loginPanel;
    private LibrarySharingFriendListPanel friendListPanel;
    private LibrarySharingEditablePanel editablePanel;
    private final JPanel component;
    private final CardLayout layout = new CardLayout();
    private final Map<String, JComponent> layoutMap = new HashMap<String, JComponent>();
    private final EventBean<FriendConnectionEvent> connectionEvent;
    private final ListEventListener<String> friendsListener;
    private View currentView = View.NONE;
    private SharedFileList currentList;

    @Inject
    public LibrarySharingPanel(Provider<LibrarySharingLoginPanel> loginPanel, Provider<LibrarySharingFriendListPanel> nonEditablePanel, Provider<LibrarySharingEditablePanel> editablePanel, EventBean<FriendConnectionEvent> connectionEvent, Provider<AutoLoginService> autoLoginServiceProvider) {
        this.loginPanelProvider = loginPanel;
        this.friendListPanelProvider = nonEditablePanel;
        this.editablePanelProvider = editablePanel;
        this.connectionEvent = connectionEvent;
        this.friendsListener = new FriendsListener();
        this.autoLoginServiceProvider = autoLoginServiceProvider;
        GuiUtils.assignResources(this);
        this.component = new JPanel();
        this.component.setMaximumSize(new Dimension(134, Integer.MAX_VALUE));
        this.component.setBackground(this.backgroundColor);
        this.component.setVisible(false);
        this.component.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.borderColor));
        this.component.setLayout(this.layout);
    }

    @Inject
    void register(ListenerSupport<FriendConnectionEvent> connectionEvent, @Named(value="known") ListenerSupport<FriendEvent> friendSupport) {
        connectionEvent.addListener(new EventListener<FriendConnectionEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(FriendConnectionEvent event) {
                if (LibrarySharingPanel.this.component.isVisible()) {
                    if (!LibrarySharingPanel.this.isLoggedIn()) {
                        LibrarySharingPanel.this.showLoginView();
                    } else if (LibrarySharingPanel.this.currentView == View.LOGIN) {
                        if (SwingUiSettings.SHOW_SHARING_OVERLAY_MESSAGE.getValue()) {
                            LibrarySharingPanel.this.showEditableView();
                        } else {
                            LibrarySharingPanel.this.showFriendListView();
                        }
                    }
                }
            }
        });
        friendSupport.addListener(new EventListener<FriendEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(FriendEvent event) {
                if (LibrarySharingPanel.this.currentView == View.EDIT_LIST) {
                    LibrarySharingPanel.this.editablePanel.refreshSelectedList();
                }
            }
        });
    }

    void showLoginView() {
        if (!this.layoutMap.containsKey(LOGIN_VIEW)) {
            this.loginPanel = this.loginPanelProvider.get();
            JComponent newComponent = this.loginPanel.getComponent();
            this.component.add((Component)newComponent, LOGIN_VIEW);
            this.layoutMap.put(LOGIN_VIEW, newComponent);
        }
        this.currentView = View.LOGIN;
        this.loginPanel.setLoggingIn(this.isLoggingIn());
        this.sharesChanged();
        this.getComponent().firePropertyChange(EDIT_MODE, true, false);
        this.layout.show(this.component, LOGIN_VIEW);
    }

    void showEditableView() {
        if (!this.layoutMap.containsKey(EDITABLE_VIEW)) {
            this.editablePanel = this.editablePanelProvider.get();
            JComponent newComponent = this.editablePanel.getComponent();
            this.component.add((Component)newComponent, EDITABLE_VIEW);
            this.layoutMap.put(EDITABLE_VIEW, newComponent);
        }
        this.currentView = View.EDIT_LIST;
        this.editablePanel.editWithSelectedIds(this.currentList.getFriendIds());
        this.getComponent().firePropertyChange(EDIT_MODE, false, true);
        this.layout.show(this.component, EDITABLE_VIEW);
    }

    void showFriendListView() {
        if (!this.layoutMap.containsKey(FRIEND_LIST_VIEW)) {
            this.friendListPanel = this.friendListPanelProvider.get();
            JComponent newComponent = this.friendListPanel.getComponent();
            this.component.add((Component)newComponent, FRIEND_LIST_VIEW);
            this.layoutMap.put(FRIEND_LIST_VIEW, newComponent);
        }
        this.currentView = View.FRIEND_LIST;
        this.sharesChanged();
        this.getComponent().firePropertyChange(EDIT_MODE, true, false);
        this.layout.show(this.component, FRIEND_LIST_VIEW);
    }

    void stopSharing() {
        this.currentList.setFriendList(Collections.<String>emptyList());
    }

    void setFriendIdsForSharing(List<String> friendIds) {
        this.currentList.setFriendList(friendIds);
    }

    private void sharesChanged() {
        if (this.currentList != null) {
            switch (this.currentView) {
                case FRIEND_LIST: {
                    this.friendListPanel.setSharedFriendIds(this.currentList.getFriendIds());
                    break;
                }
                case LOGIN: {
                    this.loginPanel.setSharedFriendIds(this.currentList.getFriendIds());
                }
            }
        }
    }

    public void setSharedFileList(SharedFileList newList) {
        if (this.currentList != newList) {
            if (this.currentList != null) {
                this.currentList.getFriendIds().removeListEventListener(this.friendsListener);
            }
            this.currentList = newList;
            this.currentList.getFriendIds().addListEventListener(this.friendsListener);
        }
        if (this.isLoggedIn()) {
            if (SwingUiSettings.SHOW_SHARING_OVERLAY_MESSAGE.getValue()) {
                this.showEditableView();
            } else {
                this.showFriendListView();
            }
        } else {
            this.showLoginView();
        }
    }

    public void showEditMode() {
        if (this.isLoggedIn()) {
            this.showEditableView();
        }
    }

    public JComponent getComponent() {
        return this.component;
    }

    private boolean isLoggedIn() {
        if (this.connectionEvent.getLastEvent() == null) {
            return false;
        }
        return this.connectionEvent.getLastEvent().getType() == FriendConnectionEvent.Type.CONNECTED;
    }

    private boolean isLoggingIn() {
        if (this.autoLoginServiceProvider.get().isAttemptingLogin()) {
            return true;
        }
        if (this.connectionEvent.getLastEvent() == null) {
            return false;
        }
        return this.connectionEvent.getLastEvent().getType() == FriendConnectionEvent.Type.CONNECTING;
    }

    private class FriendsListener
    implements ListEventListener<String> {
        private FriendsListener() {
        }

        @Override
        public void listChanged(ListEvent<String> listChanges) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LibrarySharingPanel.this.sharesChanged();
                }
            });
        }
    }

    private static enum View {
        NONE,
        LOGIN,
        FRIEND_LIST,
        EDIT_LIST;

    }
}

