/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.navigator;

import ca.odell.glazedlists.CompositeList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.impl.swing.SwingThreadProxyEventList;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.DropMode;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.jdesktop.application.Resource;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.inject.LazySingleton;
import org.limewire.ui.swing.library.navigator.LibraryNavItem;
import org.limewire.ui.swing.library.navigator.LibraryNavTableEditor;
import org.limewire.ui.swing.library.navigator.LibraryNavTransferHandler;
import org.limewire.ui.swing.nav.NavCategory;
import org.limewire.ui.swing.nav.NavItem;
import org.limewire.ui.swing.nav.Navigator;
import org.limewire.ui.swing.table.GlazedJXTable;
import org.limewire.ui.swing.table.SingleColumnTableFormat;
import org.limewire.ui.swing.table.TablePopupHandler;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.SwingHacks;

@LazySingleton
public class LibraryNavigatorTable
extends GlazedJXTable {
    @Resource
    private Color backgroundColor;
    private TablePopupHandler popupHandler;
    private final Provider<Navigator> navigatorProvider;
    private SwingThreadProxyEventList<LibraryNavItem> stpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public LibraryNavigatorTable(LibraryNavTransferHandler libraryNavTransferHandler, LibraryManager libraryManager, SharedFileListManager sharedFileListManager, Provider<Navigator> navigatorProvider) {
        this.navigatorProvider = navigatorProvider;
        GuiUtils.assignResources(this);
        this.initialize();
        EventList<SharedFileList> privateLists = sharedFileListManager.getModel();
        FunctionList<SharedFileList, LibraryNavItem> shareToNav = GlazedListsFactory.functionList(privateLists, new FunctionList.AdvancedFunction<SharedFileList, LibraryNavItem>(){

            @Override
            public void dispose(SharedFileList sourceValue, LibraryNavItem transformedValue) {
            }

            @Override
            public LibraryNavItem evaluate(SharedFileList sourceValue) {
                return new LibraryNavItem(sourceValue);
            }

            @Override
            public LibraryNavItem reevaluate(SharedFileList sourceValue, LibraryNavItem transformedValue) {
                return transformedValue;
            }
        });
        CompositeList<LibraryNavItem> compositeList = new CompositeList<LibraryNavItem>(privateLists.getPublisher(), privateLists.getReadWriteLock());
        compositeList.getReadWriteLock().writeLock().lock();
        try {
            EventList<LibraryNavItem> libraryList = compositeList.createMemberList();
            libraryList.add(new LibraryNavItem(libraryManager.getLibraryManagedList()));
            compositeList.addMemberList(libraryList);
            compositeList.addMemberList(shareToNav);
        }
        finally {
            compositeList.getReadWriteLock().writeLock().unlock();
        }
        SortedList<LibraryNavItem> sortedList = GlazedListsFactory.sortedList(compositeList, new LibraryNavItemComparator());
        this.stpl = GlazedListsFactory.swingThreadProxyEventList(sortedList);
        this.setModel(new DefaultEventTableModel<LibraryNavItem>(this.stpl, new SingleColumnTableFormat("")));
        this.setDropMode(DropMode.ON);
        this.setTransferHandler(libraryNavTransferHandler);
        SwingHacks.fixDnDforKDE(this);
        this.setEditable(false);
    }

    public void selectLibraryNavItem(int id) {
        this.showNavTableIfHidden();
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            Object value = this.getModel().getValueAt(i, 0);
            if (!(value instanceof LibraryNavItem) || ((LibraryNavItem)value).getId() != id) continue;
            this.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    public void selectLibraryNavItem(LocalFileList sharedFileList) {
        this.showNavTableIfHidden();
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            Object value = this.getModel().getValueAt(i, 0);
            if (!(value instanceof LibraryNavItem) || ((LibraryNavItem)value).getLocalFileList() != sharedFileList) continue;
            this.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    private void showNavTableIfHidden() {
        if (!this.isShowing()) {
            NavItem item = this.navigatorProvider.get().getNavItem(NavCategory.LIBRARY, "Library");
            item.select();
        }
    }

    public LibraryNavItem getSelectedItem() {
        int selected = this.getSelectedRow();
        if (selected < 0) {
            this.getSelectionModel().setSelectionInterval(0, 0);
            selected = 0;
        }
        return (LibraryNavItem)this.getModel().getValueAt(selected, 0);
    }

    private void initialize() {
        this.setFillsViewportHeight(true);
        this.setBackground(this.backgroundColor);
        this.setShowGrid(false, false);
        this.setTableHeader(null);
        this.setRowHeight(24);
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger() && LibraryNavigatorTable.this.popupHandler != null) {
                    int col = LibraryNavigatorTable.this.columnAtPoint(e.getPoint());
                    int row = LibraryNavigatorTable.this.rowAtPoint(e.getPoint());
                    if (row >= 0 && col >= 0) {
                        LibraryNavigatorTable.this.popupHandler.maybeShowPopup(e.getComponent(), e.getX(), e.getY());
                        TableCellEditor editor = LibraryNavigatorTable.this.getCellEditor();
                        if (editor != null) {
                            editor.cancelCellEditing();
                        }
                    }
                }
            }
        });
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(super.getPreferredScrollableViewportSize().width, this.getModel().getRowCount() * this.getRowHeight());
    }

    public void setPopupHandler(TablePopupHandler popupHandler) {
        this.popupHandler = popupHandler;
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            Object value = editor.getCellEditorValue();
            if (value instanceof String) {
                this.handleRename((String)value);
            }
            this.removeEditor();
        }
        this.setEditable(false);
    }

    private void handleRename(String newName) {
        SharedFileList sharedFileList;
        if (newName == null || newName.length() == 0) {
            return;
        }
        LibraryNavItem item = this.getSelectedItem();
        LocalFileList fileList = item.getLocalFileList();
        if (fileList instanceof SharedFileList && (sharedFileList = (SharedFileList)fileList).isNameChangeAllowed() && !sharedFileList.getCollectionName().equals(newName)) {
            sharedFileList.setCollectionName(newName);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.isEditable() && row < this.getRowCount() && col < this.getColumnCount() && row >= 2 && col >= 0;
    }

    @Override
    public boolean editCellAt(int row, int column) {
        if (super.editCellAt(row, column)) {
            LibraryNavTableEditor editor = (LibraryNavTableEditor)this.getCellEditor();
            editor.prepareForEditing();
            return true;
        }
        return false;
    }

    public int getPrivateSharedLibraryCount() {
        int numberOfPrivateSharedLibraries = 0;
        for (LibraryNavItem item : this.stpl) {
            if (item.getType() != LibraryNavItem.NavType.LIST) continue;
            ++numberOfPrivateSharedLibraries;
        }
        return numberOfPrivateSharedLibraries;
    }

    private static class LibraryNavItemComparator
    implements Comparator<LibraryNavItem> {
        private LibraryNavItemComparator() {
        }

        @Override
        public int compare(LibraryNavItem nav1, LibraryNavItem nav2) {
            LibraryNavItem.NavType type1 = nav1.getType();
            LibraryNavItem.NavType type2 = nav2.getType();
            if (type1 == LibraryNavItem.NavType.LIBRARY) {
                return -1;
            }
            if (type2 == LibraryNavItem.NavType.LIBRARY) {
                return 1;
            }
            if (type1 == LibraryNavItem.NavType.PUBLIC_SHARED) {
                return -1;
            }
            if (type2 == LibraryNavItem.NavType.PUBLIC_SHARED) {
                return 1;
            }
            return 0;
        }
    }
}

