/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.navigator;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.ui.swing.library.navigator.LibraryNavigatorPanel;
import org.limewire.ui.swing.library.navigator.LibraryNavigatorTable;
import org.limewire.ui.swing.util.I18n;

public class CreateListAction
extends AbstractAction {
    private final Provider<SharedFileListManager> shareManager;
    private final Provider<LibraryNavigatorTable> navTable;
    private final Provider<LibraryNavigatorPanel> libraryNavigatorPanel;

    @Inject
    public CreateListAction(Provider<SharedFileListManager> shareManager, Provider<LibraryNavigatorTable> navTable, Provider<LibraryNavigatorPanel> libraryNavigatorPanel) {
        super("Create New List");
        this.shareManager = shareManager;
        this.navTable = navTable;
        this.libraryNavigatorPanel = libraryNavigatorPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int id = this.shareManager.get().createNewSharedFileList(I18n.tr("Untitled"));
        this.navTable.get().selectLibraryNavItem(id);
        SharedFileList sharedFileList = (SharedFileList)this.libraryNavigatorPanel.get().getSelectedNavItem().getLocalFileList();
        this.libraryNavigatorPanel.get().editSharedListName(sharedFileList);
    }
}

