/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.images;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.ui.swing.images.ImageRenderer;
import org.limewire.ui.swing.images.ThumbnailManager;
import org.limewire.ui.swing.library.table.RemoveButton;
import org.limewire.ui.swing.util.GuiUtils;

public class ImageCellRenderer
extends JPanel
implements ListCellRenderer {
    protected Border border;
    private final ThumbnailManager thumbnailManager;
    private final ImageRenderer imageRenderer;
    private final RemoveButton removeButton;
    @Resource
    protected Color cellBackgroundColor;
    @Resource
    protected Color cellBorderColor;
    @Resource
    protected Color cellSelectedBackground;
    @Resource
    protected Icon errorIcon;
    @Resource
    private int height;
    @Resource
    private int width;
    @Resource
    private int insetTop;
    @Resource
    private int insetBottom;
    @Resource
    private int insetLeft;
    @Resource
    private int insetRight;

    @Inject
    public ImageCellRenderer(ThumbnailManager thumbnailManager, ImageRenderer imageRenderer, RemoveButton removeButton) {
        this.thumbnailManager = thumbnailManager;
        this.imageRenderer = imageRenderer;
        this.removeButton = removeButton;
        GuiUtils.assignResources(this);
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.setSize(this.getPreferredSize());
        this.setBackground(this.cellBackgroundColor);
        this.setLayout(new MigLayout("insets 0, gap 0, fill"));
        this.add((Component)removeButton, "gaptop 5, gapright 5, alignx right, aligny top, wrap");
        this.add((Component)imageRenderer, "grow, alignx 50%");
        this.border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(this.insetTop, this.insetLeft, this.insetBottom, this.insetRight), BorderFactory.createMatteBorder(1, 1, 1, 1, this.cellBorderColor));
    }

    public Insets getPaddingInsets() {
        return new Insets(this.insetTop, this.insetLeft, this.insetBottom, this.insetRight);
    }

    public void setShowButtons(boolean value) {
        this.removeButton.setVisible(value);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        LocalFileItem item = (LocalFileItem)value;
        this.imageRenderer.setIcon(this.thumbnailManager.getThumbnailForFile(item.getFile(), list, index));
        if (this.thumbnailManager.isErrorIcon(item.getFile())) {
            this.imageRenderer.setText(item.getFileName());
        } else {
            this.imageRenderer.setText("");
        }
        this.setToolTipText(item.getFileName());
        if (isSelected) {
            this.setBackground(this.cellSelectedBackground);
        } else {
            this.setBackground(this.cellBackgroundColor);
        }
        this.setBorder(this.border);
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(this.insetLeft, this.insetTop, this.getWidth() - this.insetLeft - this.insetRight, this.getHeight() - this.insetTop - this.insetBottom);
        super.paintComponent(g);
    }
}

