/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.limewire.ui.swing.components.RolloverCursorListener;
import org.limewire.ui.swing.filter.AbstractFilter;
import org.limewire.ui.swing.util.I18n;

class FilterPopupPanel
extends JPanel {
    private static final int MAX_VISIBLE_ROWS = 18;
    private final JPanel titlePanel = new JPanel();
    private final JLabel titleLabel = new JLabel();
    private final JButton closeButton = new JButton();
    private final JXList list = new JXList();
    private final JScrollPane scrollPane = new JScrollPane();
    private final JPopupMenu popupMenu = new JPopupMenu();
    private boolean popupReady;
    private boolean popupTriggered;

    public FilterPopupPanel(AbstractFilter.FilterResources resources, String titleText) {
        this.setBorder(BorderFactory.createLineBorder(resources.getPopupBorderColor(), 2));
        this.setLayout(new BorderLayout());
        this.titlePanel.setBackground(resources.getPopupHeaderBackground());
        this.titlePanel.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 1));
        this.titlePanel.setLayout(new BorderLayout());
        this.titleLabel.setForeground(resources.getPopupHeaderForeground());
        this.titleLabel.setFont(resources.getPopupHeaderFont());
        this.titleLabel.setText(I18n.tr("All {0}", titleText));
        this.closeButton.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.setForeground(resources.getPopupHeaderForeground());
        this.closeButton.setIcon(resources.getPopupCloseIcon());
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterPopupPanel.this.hidePopup();
            }
        });
        new RolloverCursorListener().install(this.closeButton);
        this.list.setFont(resources.getRowFont());
        this.list.setForeground(resources.getRowColor());
        this.list.setOpaque(false);
        this.list.setRolloverEnabled(true);
        this.list.setSelectionMode(0);
        this.list.setHighlighters(new ColorHighlighter(HighlightPredicate.ROLLOVER_ROW, resources.getHighlightBackground(), resources.getHighlightForeground()));
        new RolloverCursorListener().install(this.list);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setViewportView(this.list);
        this.popupMenu.setBorder(BorderFactory.createEmptyBorder());
        this.popupMenu.setFocusable(false);
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (FilterPopupPanel.this.popupTriggered) {
                    FilterPopupPanel.this.popupReady = false;
                } else {
                    FilterPopupPanel.this.popupReady = true;
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                FilterPopupPanel.this.popupTriggered = true;
            }
        });
        this.add((Component)this.titlePanel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.titlePanel.add((Component)this.titleLabel, "Center");
        this.titlePanel.add((Component)this.closeButton, "East");
        this.popupMenu.add(this);
    }

    public void setListCellRenderer(ListCellRenderer renderer) {
        this.list.setCellRenderer(renderer);
    }

    public void setListModel(ListModel model) {
        this.list.setModel(model);
    }

    public void setListSelectionModel(ListSelectionModel selectionModel) {
        this.list.setSelectionModel(selectionModel);
    }

    public boolean isPopupReady() {
        return this.popupReady;
    }

    public void setPopupReady(boolean popupReady) {
        this.popupReady = popupReady;
    }

    public void setPopupTriggered(boolean popupTriggered) {
        this.popupTriggered = popupTriggered;
    }

    public void showPopup(Component invoker, int x, int y) {
        this.list.setVisibleRowCount(Math.min(this.list.getModel().getSize(), 18));
        if (this.popupMenu.getPreferredSize().width > 275) {
            this.popupMenu.setPreferredSize(new Dimension(275, this.popupMenu.getPreferredSize().height));
        }
        this.popupMenu.show(invoker, x, y);
    }

    public void hidePopup() {
        this.popupMenu.setVisible(false);
    }
}

