/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import com.google.inject.Provider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.core.api.Category;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.core.api.search.SearchDetails;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.Line;
import org.limewire.ui.swing.components.PromptTextField;
import org.limewire.ui.swing.components.SideLineBorder;
import org.limewire.ui.swing.components.decorators.TextFieldDecorator;
import org.limewire.ui.swing.filter.ActiveFilterPanel;
import org.limewire.ui.swing.filter.CategoryDetector;
import org.limewire.ui.swing.filter.CategoryFilter;
import org.limewire.ui.swing.filter.Filter;
import org.limewire.ui.swing.filter.FilterInspectionUtils;
import org.limewire.ui.swing.filter.FilterListener;
import org.limewire.ui.swing.filter.FilterManager;
import org.limewire.ui.swing.filter.FilterableItem;
import org.limewire.ui.swing.filter.FilterableItemTextFilterator;
import org.limewire.ui.swing.filter.FilterableSource;
import org.limewire.ui.swing.filter.SourceFilter;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.IconManager;

public class AdvancedFilterPanel<E extends FilterableItem>
extends JPanel
implements Disposable {
    private static final int LEFT_INSET = 6;
    private static final int RIGHT_INSET = 6;
    @Resource(key="AdvancedFilter.filterWidth")
    private int filterWidth;
    @Resource(key="AdvancedFilter.background")
    private Color background;
    @Resource
    private Color borderColor;
    @Resource
    private Color dividerBackground;
    @Resource
    private Color dividerForeground;
    @Resource
    private Font moreTextFont;
    @Resource
    private Font resetTextFont;
    private final FilterableSource<E> filterableSource;
    private final EventList<MatcherEditor<E>> editorList;
    private final FilterManager<E> filterManager;
    private final List<CategoryListener> listenerList = new ArrayList<CategoryListener>();
    private final CategoryFilter<E> categoryFilter;
    private final SourceFilter<E> sourceFilter;
    private final PromptTextField filterTextField = new PromptTextField(I18n.tr("Refine results..."));
    private final FilterDisplayPanel filterDisplayPanel;
    private final JPanel filterPanel = new JPanel();
    private final Line upperDividerLine;
    private final Line lowerDividerLine;
    private final JScrollPane filterScrollPane = new JScrollPane();
    private final PropertyFilterPanel propertyPanel;
    private SearchCategory defaultDisplayCategory;
    private SearchCategory defaultFilterCategory;
    private boolean layoutAdjusting;

    public AdvancedFilterPanel(FilterableSource<E> filterableSource, TextFieldDecorator textFieldDecorator, Provider<IconManager> iconManager, SearchDetails.SearchType type) {
        this.filterableSource = filterableSource;
        this.editorList = new BasicEventList<MatcherEditor<E>>();
        this.filterManager = new FilterManager<E>(filterableSource, iconManager);
        if (filterableSource.getFilterDebugger() != null) {
            filterableSource.getFilterDebugger().initialize(this.filterManager);
        }
        GuiUtils.assignResources(this);
        this.setBackground(this.background);
        this.setBorder(new SideLineBorder(this.borderColor, SideLineBorder.Side.RIGHT));
        this.setLayout(new MigLayout("insets 0 0 0 0, gap 0!, fill, hidemode 3"));
        int textFieldWidth = this.filterWidth - 6 - 6;
        textFieldDecorator.decorateClearablePromptField(this.filterTextField, BorderPainter.AccentType.NONE);
        this.filterTextField.setMinimumSize(new Dimension(textFieldWidth, this.filterTextField.getMinimumSize().height));
        this.filterTextField.setPreferredSize(new Dimension(textFieldWidth, this.filterTextField.getPreferredSize().height));
        this.filterDisplayPanel = new FilterDisplayPanel();
        this.filterPanel.setBackground(this.background);
        this.filterPanel.setLayout(new MigLayout("insets 0 0 0 0, gap 0!, hidemode 3", "[grow]", ""));
        this.upperDividerLine = Line.createHorizontalLine(this.dividerForeground);
        this.lowerDividerLine = Line.createHorizontalLine(this.dividerBackground);
        this.filterScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.filterScrollPane.setHorizontalScrollBarPolicy(31);
        this.filterScrollPane.setViewportView(this.filterPanel);
        this.filterScrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.filterScrollPane.getVerticalScrollBar().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (!AdvancedFilterPanel.this.layoutAdjusting) {
                    AdvancedFilterPanel.this.doFilterLayout();
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                if (!AdvancedFilterPanel.this.layoutAdjusting) {
                    AdvancedFilterPanel.this.doFilterLayout();
                }
            }
        });
        this.propertyPanel = new PropertyFilterPanel();
        this.categoryFilter = this.filterManager.getCategoryFilter();
        JComponent categoryComp = this.categoryFilter.getComponent();
        categoryComp.setVisible(filterableSource.getFilterCategory() == SearchCategory.ALL);
        this.sourceFilter = this.filterManager.getSourceFilter();
        this.sourceFilter.getComponent().setVisible(false);
        if (type != SearchDetails.SearchType.SINGLE_BROWSE) {
            this.sourceFilter.addFriendListener(new SourceFilter.FriendListener(){

                @Override
                public void friendFound(boolean found) {
                    if (!AdvancedFilterPanel.this.sourceFilter.isActive()) {
                        AdvancedFilterPanel.this.sourceFilter.getComponent().setVisible(found);
                    }
                }
            });
        }
        this.add((Component)this.filterTextField, "gap 6 6 6 6, growx, wrap");
        this.add((Component)this.filterDisplayPanel, "gap 0 0 2 0, growx, wrap");
        this.add((Component)this.upperDividerLine, "gap 0 0 6 0, hmin 1, growx, wrap");
        this.add((Component)this.lowerDividerLine, "gap 0 0 0 0, hmin 1, growx, wrap");
        this.add((Component)this.filterScrollPane, "gap 0 0 0 0, grow, push");
        this.doFilterLayout();
        this.configureFilters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilterLayout() {
        this.layoutAdjusting = true;
        try {
            JScrollBar scrollBar = this.filterScrollPane.getVerticalScrollBar();
            int maxWidth = this.filterWidth - (scrollBar.isVisible() ? scrollBar.getWidth() : 0);
            this.filterPanel.removeAll();
            this.filterPanel.add((Component)this.categoryFilter.getComponent(), "gap 0 0 8 6, wmax " + maxWidth + ", growx, wrap");
            this.filterPanel.add((Component)this.sourceFilter.getComponent(), "gap 0 0 8 6, wmax " + maxWidth + ", growx, wrap");
            this.filterPanel.add((Component)this.propertyPanel, "gap 0 0 0 0, wmax " + maxWidth + ", grow");
            this.updateDivider();
            this.validate();
            this.repaint();
        }
        finally {
            this.layoutAdjusting = false;
        }
    }

    private void updateDivider() {
        boolean visible = this.filterDisplayPanel.isVisible() || this.filterScrollPane.getVerticalScrollBar().isVisible();
        this.upperDividerLine.setVisible(visible);
        this.lowerDividerLine.setVisible(visible);
    }

    private void configureFilters() {
        TextComponentMatcherEditor editor = new TextComponentMatcherEditor(this.filterTextField, new FilterableItemTextFilterator(), true);
        this.filterTextField.addKeyListener(new InpsectionKeyListener());
        this.editorList.add(editor);
        CompositeMatcherEditor<E> compositeEditor = new CompositeMatcherEditor<E>(this.editorList);
        this.filterableSource.setFilterEditor(compositeEditor);
        this.filterDisplayPanel.setVisible(false);
        this.categoryFilter.addFilterListener(new AddFilterListener());
        this.sourceFilter.addFilterListener(new AddFilterListener());
    }

    private void addActiveFilter(Filter<E> filter) {
        MatcherEditor<E> editor = filter.getMatcherEditor();
        if (editor != null && !this.editorList.contains(editor)) {
            this.editorList.add(editor);
        }
        this.filterDisplayPanel.addFilter(filter);
    }

    private void removeActiveFilter(Filter<E> filter) {
        this.filterDisplayPanel.removeFilter(filter);
        MatcherEditor<E> editor = filter.getMatcherEditor();
        if (editor != null && this.editorList.contains(editor)) {
            this.editorList.remove(editor);
        }
        filter.reset();
    }

    private void updateCategory() {
        if (this.categoryFilter.isActive()) {
            Category category = this.categoryFilter.getSelectedCategory();
            SearchCategory displayCategory = SearchCategory.forCategory(category);
            this.propertyPanel.setFilterCategory(displayCategory);
            this.fireCategorySelected(displayCategory);
        } else if (this.categoryFilter.getCategoryCount() == 1) {
            Category category = this.categoryFilter.getDefaultCategory();
            SearchCategory displayCategory = SearchCategory.forCategory(category);
            this.propertyPanel.setFilterCategory(displayCategory);
            this.fireCategorySelected(displayCategory);
        } else {
            this.propertyPanel.setFilterCategory(this.defaultFilterCategory);
            this.fireCategorySelected(this.defaultDisplayCategory);
        }
    }

    public void addCategoryListener(CategoryListener listener) {
        this.listenerList.add(listener);
    }

    public void removeCategoryListener(CategoryListener listener) {
        this.listenerList.remove(listener);
    }

    private void fireCategorySelected(SearchCategory displayCategory) {
        int size = this.listenerList.size();
        for (int i = 0; i < size; ++i) {
            this.listenerList.get(i).categorySelected(displayCategory);
        }
    }

    public void setSearchCategory(SearchCategory searchCategory) {
        this.defaultDisplayCategory = searchCategory;
        this.defaultFilterCategory = searchCategory;
        if (searchCategory == SearchCategory.ALL) {
            CategoryDetector<E> detector = new CategoryDetector<E>(this.filterableSource, this.categoryFilter);
            detector.start(new CategoryDetector.CategoryDetectorListener(){

                @Override
                public void categoryFound(Category category) {
                    AdvancedFilterPanel.this.defaultFilterCategory = category != null ? SearchCategory.forCategory(category) : SearchCategory.ALL;
                    AdvancedFilterPanel.this.propertyPanel.setFilterCategory(AdvancedFilterPanel.this.defaultFilterCategory);
                }
            });
        } else {
            this.propertyPanel.setFilterCategory(this.defaultFilterCategory);
        }
    }

    @Override
    public void dispose() {
        this.filterManager.dispose();
    }

    private static class InpsectionKeyListener
    extends KeyAdapter {
        private InpsectionKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            FilterInspectionUtils.filterUsed();
            FilterInspectionUtils.refineBoxUsed();
        }
    }

    public static interface CategoryListener {
        public void categorySelected(SearchCategory var1);
    }

    private class PropertyFilterPanel
    extends JPanel
    implements FilterListener<E> {
        private final HyperlinkButton moreButton = new HyperlinkButton();
        private final MoreFilterAction moreFilterAction = new MoreFilterAction();
        private final Map<SearchCategory, Boolean> showAllMap = new EnumMap<SearchCategory, Boolean>(SearchCategory.class);
        private List<Filter<E>> filterList = Collections.emptyList();
        private SearchCategory currentCategory;

        public PropertyFilterPanel() {
            this.setLayout(new MigLayout("insets 0 0 0 0, gap 0!, hidemode 3", "[grow]", ""));
            this.setOpaque(false);
            this.moreButton.setAction(this.moreFilterAction);
            this.moreButton.setFont(AdvancedFilterPanel.this.moreTextFont);
        }

        public void setFilterCategory(SearchCategory filterCategory) {
            if (this.currentCategory == filterCategory) {
                return;
            }
            this.currentCategory = filterCategory;
            List oldFilterList = this.filterList;
            this.filterList = AdvancedFilterPanel.this.filterManager.getPropertyFilterList(filterCategory);
            int filterMin = AdvancedFilterPanel.this.filterManager.getPropertyFilterMinimum(filterCategory);
            this.removeAll();
            for (Filter filter : oldFilterList) {
                filter.removeFilterListener(this);
                if (this.filterList.contains(filter)) continue;
                AdvancedFilterPanel.this.removeActiveFilter(filter);
            }
            int size = this.filterList.size();
            for (int i = 0; i < size; ++i) {
                Filter filter = this.filterList.get(i);
                JComponent component = filter.getComponent();
                this.add((Component)component, "gap 0 0 8 6, aligny top, growx, wrap");
                if (!filter.isActive()) {
                    component.setVisible(this.isFilterVisible(i));
                }
                filter.addFilterListener(this);
            }
            if (filterMin > 0 && this.filterList.size() > filterMin) {
                this.add((Component)this.moreButton, "gap 6 6 8 3, aligny top");
            }
            this.moreFilterAction.update(this.isShowAll());
            this.validate();
            this.repaint();
        }

        public void setShowAll(boolean showAll) {
            this.showAllMap.put(this.currentCategory, showAll);
            int size = this.filterList.size();
            for (int i = 0; i < size; ++i) {
                Filter filter = this.filterList.get(i);
                JComponent component = filter.getComponent();
                if (filter.isActive()) continue;
                component.setVisible(this.isFilterVisible(i));
            }
        }

        public boolean isShowAll() {
            Boolean showAll = this.showAllMap.get((Object)this.currentCategory);
            return showAll != null ? showAll : false;
        }

        private boolean isFilterVisible(int index) {
            boolean visible = this.isShowAll();
            if (!visible) {
                int filterMin = AdvancedFilterPanel.this.filterManager.getPropertyFilterMinimum(this.currentCategory);
                visible = filterMin < 1 || index < filterMin;
            }
            return visible;
        }

        @Override
        public void filterChanged(Filter<E> filter) {
            if (filter.isActive()) {
                AdvancedFilterPanel.this.addActiveFilter(filter);
            } else {
                AdvancedFilterPanel.this.removeActiveFilter(filter);
            }
            AdvancedFilterPanel.this.updateCategory();
        }
    }

    private class FilterDisplayPanel
    extends JPanel {
        private final JPanel displayPanel = new JPanel();
        private final HyperlinkButton resetButton = new HyperlinkButton();
        private final Map<Filter<E>, ActiveFilterPanel> displayMap = new HashMap();

        public FilterDisplayPanel() {
            this.setLayout(new MigLayout("insets 0 0 0 0, gap 0!, hidemode 3", "[grow]", ""));
            this.setOpaque(false);
            this.displayPanel.setLayout(new MigLayout("insets 0 0 0 0, gap 0!", "[grow]", ""));
            this.displayPanel.setOpaque(false);
            this.resetButton.setAction(new RemoveAllAction());
            this.resetButton.setFont(AdvancedFilterPanel.this.resetTextFont);
            this.add((Component)this.displayPanel, "gap 6 6 0 0, growx, wrap");
            this.add((Component)this.resetButton, "gap 6 6 0 0, alignx right, wrap");
        }

        public void addFilter(Filter<E> filter) {
            if (this.displayMap.get(filter) != null) {
                this.removeFilter(filter);
            }
            ActiveFilterPanel activeFilterPanel = new ActiveFilterPanel(new RemoveFilterAction(filter));
            this.displayMap.put(filter, activeFilterPanel);
            int maxWidth = AdvancedFilterPanel.this.filterWidth - 6 - 6;
            this.displayPanel.add((Component)activeFilterPanel, "gaptop 4, wmax " + maxWidth + ", wrap");
            this.setVisible(true);
            AdvancedFilterPanel.this.updateDivider();
            AdvancedFilterPanel.this.validate();
            AdvancedFilterPanel.this.repaint();
        }

        public void removeFilter(Filter<E> filter) {
            ActiveFilterPanel activeFilterPanel = this.displayMap.get(filter);
            if (activeFilterPanel != null) {
                this.displayPanel.remove(activeFilterPanel);
            }
            this.displayMap.remove(filter);
            if (this.displayMap.size() < 1) {
                this.setVisible(false);
                AdvancedFilterPanel.this.updateDivider();
            }
            AdvancedFilterPanel.this.validate();
            AdvancedFilterPanel.this.repaint();
        }

        public List<Filter<E>> getActiveFilters() {
            return new ArrayList(this.displayMap.keySet());
        }
    }

    private class MoreFilterAction
    extends AbstractAction {
        private final String MORE = I18n.tr("more filters");
        private final String LESS = I18n.tr("fewer filters");

        public MoreFilterAction() {
            this.putValue("Name", this.MORE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterInspectionUtils.moreFiltersClicked();
            AdvancedFilterPanel.this.propertyPanel.setShowAll(!AdvancedFilterPanel.this.propertyPanel.isShowAll());
            this.update(AdvancedFilterPanel.this.propertyPanel.isShowAll());
        }

        public void update(boolean showAll) {
            this.putValue("Name", showAll ? this.LESS : this.MORE);
        }
    }

    private class RemoveFilterAction
    extends AbstractAction {
        private final Filter<E> filter;

        public RemoveFilterAction(Filter<E> filter) {
            this.filter = filter;
            this.putValue("Name", filter.getActiveText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdvancedFilterPanel.this.removeActiveFilter(this.filter);
            AdvancedFilterPanel.this.updateCategory();
        }
    }

    private class RemoveAllAction
    extends AbstractAction {
        public RemoveAllAction() {
            this.putValue("Name", I18n.tr("reset"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdvancedFilterPanel.this.filterTextField.setText(null);
            List filterList = AdvancedFilterPanel.this.filterDisplayPanel.getActiveFilters();
            for (Filter filter : filterList) {
                AdvancedFilterPanel.this.removeActiveFilter(filter);
            }
            AdvancedFilterPanel.this.updateCategory();
        }
    }

    private class AddFilterListener
    implements FilterListener<E> {
        private AddFilterListener() {
        }

        @Override
        public void filterChanged(Filter<E> filter) {
            if (filter.isActive()) {
                AdvancedFilterPanel.this.addActiveFilter(filter);
            } else {
                AdvancedFilterPanel.this.removeActiveFilter(filter);
            }
            AdvancedFilterPanel.this.updateCategory();
        }
    }
}

