/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.limewire.ui.swing.dnd.GhostDragGlassPane;

public class GhostDropTargetListener
implements DropTargetListener {
    private final GhostDragGlassPane ghostDragGlassPane;
    private final JComponent parent;
    private Point offset = new Point(8, 15);

    public GhostDropTargetListener(JComponent parent, GhostDragGlassPane ghostDragGlassPane) {
        this.parent = parent;
        this.ghostDragGlassPane = ghostDragGlassPane;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        Component component = this.getGlassPane();
        if (!(component instanceof GhostDragGlassPane) && component.isVisible()) {
            return;
        }
        if (!(component instanceof GhostDragGlassPane)) {
            SwingUtilities.getRootPane(this.parent).setGlassPane(this.ghostDragGlassPane);
        }
        this.updateText(dtde, this.ghostDragGlassPane);
        this.ghostDragGlassPane.repaint();
    }

    private void updateText(DropTargetDragEvent dtde, GhostDragGlassPane ghostPane) {
        Point p = (Point)dtde.getLocation().clone();
        SwingUtilities.convertPointToScreen(p, this.parent);
        SwingUtilities.convertPointFromScreen(p, ghostPane);
        ghostPane.setPoint(new Point(p.x + this.offset.x, p.y + this.offset.y));
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        if (!(this.getGlassPane() instanceof GhostDragGlassPane)) {
            return;
        }
        GhostDragGlassPane glassPane = (GhostDragGlassPane)this.getGlassPane();
        glassPane.setVisible(false);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (!(this.getGlassPane() instanceof GhostDragGlassPane)) {
            return;
        }
        GhostDragGlassPane glassPane = (GhostDragGlassPane)this.getGlassPane();
        Point p = (Point)dtde.getLocation().clone();
        SwingUtilities.convertPointToScreen(p, this.parent);
        SwingUtilities.convertPointFromScreen(p, glassPane);
        glassPane.setPoint(new Point(p.x + this.offset.x, p.y + this.offset.y));
        glassPane.repaint(glassPane.getRepaintRect());
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (!(this.getGlassPane() instanceof GhostDragGlassPane)) {
            return;
        }
        GhostDragGlassPane glassPane = (GhostDragGlassPane)this.getGlassPane();
        glassPane.setVisible(false);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    private Component getGlassPane() {
        return SwingUtilities.getRootPane(this.parent).getGlassPane();
    }
}

