/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components.decorators;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import org.jdesktop.application.Resource;
import org.limewire.inject.LazySingleton;
import org.limewire.ui.swing.components.HeaderBar;
import org.limewire.ui.swing.painter.factories.BarPainterFactory;
import org.limewire.ui.swing.util.GuiUtils;

@LazySingleton
public class HeaderBarDecorator {
    private final Provider<BarPainterFactory> painterFactory;
    @Resource
    private int height;
    @Resource
    private Font headingFont;
    @Resource
    private Color specialForeground;
    @Resource
    private Color basicForeground;
    @Resource
    private int defaultComponentHeight;

    @Inject
    HeaderBarDecorator(Provider<BarPainterFactory> painterFactory) {
        GuiUtils.assignResources(this);
        this.painterFactory = painterFactory;
    }

    public void decorateBasic(HeaderBar bar) {
        this.decorateCommon(bar);
        bar.setBackgroundPainter(this.painterFactory.get().createHeaderBarPainter());
        bar.setForeground(this.basicForeground);
    }

    public void decorateSpecial(HeaderBar bar) {
        this.decorateCommon(bar);
        bar.setBackgroundPainter(this.painterFactory.get().createSpecialHeaderBarPainter());
        bar.setForeground(this.specialForeground);
    }

    private void decorateCommon(HeaderBar bar) {
        bar.setMinimumSize(new Dimension(0, this.height));
        bar.setPreferredSize(new Dimension(Integer.MAX_VALUE, this.height));
        bar.setDefaultComponentHeight(this.defaultComponentHeight);
        bar.setFont(this.headingFont);
    }
}

