/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class MarqueeButton
extends JButton {
    private JToolTip toolTip = new JToolTip();
    private int position;
    private int maxPosition;
    private Timer timer;
    private int repeatCount = 5;
    private int initialDelay = 30;
    private String marqueeString;

    public MarqueeButton(String text, int maxCharsShown) {
        super(text);
        this.setHorizontalAlignment(2);
        this.toolTip.setComponent(this);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorderPainted(false);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.setOpaque(false);
        this.setFocusPainted(false);
        this.setMaxChars(maxCharsShown);
        this.setToolTipText(this.getText());
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (!event.getAncestor().isAncestorOf(MarqueeButton.this)) {
                    MarqueeButton.this.stop();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }
        });
    }

    public void start() {
        this.stop();
        StringBuilder marqueeBuilder = new StringBuilder();
        for (int i = 0; i < this.repeatCount; ++i) {
            marqueeBuilder.append(this.getText());
            if (i == this.repeatCount - 1) continue;
            marqueeBuilder.append("          ");
        }
        this.marqueeString = marqueeBuilder.toString();
        JLabel marqueeLabel = new JLabel(this.marqueeString);
        marqueeLabel.setFont(this.getFont());
        JLabel fullLabel = new JLabel(this.getText());
        fullLabel.setFont(this.getFont());
        this.maxPosition = marqueeLabel.getPreferredSize().width - fullLabel.getPreferredSize().width;
        this.position = 0;
        this.timer = new Timer(this.initialDelay, new MarqueeAction());
        this.timer.start();
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
            this.position = 0;
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setFont(this.getFont());
        FontMetrics metrics = g2.getFontMetrics();
        g2.setColor(this.getForeground());
        if (this.timer != null && this.timer.isRunning()) {
            g2.drawString(this.marqueeString, -this.position, this.getHeight() / 2 + metrics.getAscent() / 2 - 1);
        } else {
            g2.drawString(this.getText(), 0, this.getHeight() / 2 + metrics.getAscent() / 2 - 1);
        }
        g2.dispose();
    }

    public void setMaxChars(int maxCharsShown) {
        StringBuilder fillerBuilder = new StringBuilder();
        for (int i = 0; i < maxCharsShown; ++i) {
            fillerBuilder.append('X');
        }
        String oldText = this.getText();
        this.setText(fillerBuilder.toString());
        this.setMaximumSize(this.getPreferredSize());
        this.setPreferredSize(this.getMaximumSize());
        this.setText(oldText);
    }

    @Override
    public JToolTip createToolTip() {
        return this.toolTip;
    }

    public JToolTip getToolTip() {
        return this.toolTip;
    }

    private class MarqueeAction
    implements ActionListener {
        private MarqueeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MarqueeButton.this.position += 1;
            MarqueeButton.this.repaint();
            if (MarqueeButton.this.position >= MarqueeButton.this.maxPosition) {
                MarqueeButton.this.position = 0;
            }
        }
    }
}

