/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.IconManager;

public class LabelTextField
extends JPanel {
    @Resource
    private Icon folderIcon;
    private JLabel label;
    private JTextField textField;
    private MouseListener mouseListener;
    private Provider<IconManager> iconManager;

    public LabelTextField(Provider<IconManager> iconManager) {
        GuiUtils.assignResources(this);
        this.iconManager = iconManager;
        this.label = new JLabel();
        this.label.setOpaque(false);
        this.textField = new JTextField();
        this.textField.setEditable(false);
        this.textField.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.textField.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "West");
        this.add((Component)this.textField, "Center");
        this.setBackground(UIManager.getColor("TextField.disabledBackground"));
        this.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    }

    @Override
    public void setEnabled(boolean value) {
        this.textField.setEnabled(value);
    }

    public void setEditable(boolean value) {
        this.textField.setEditable(value);
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String text) {
        this.textField.setText(text);
        this.textField.setCaretPosition(0);
        try {
            Icon icon = this.iconManager.get().getIconForFile(new File(text));
            if (icon != null) {
                this.label.setIcon(icon);
            } else {
                this.label.setIcon(this.folderIcon);
            }
        }
        catch (Exception e) {
            this.label.setIcon(this.folderIcon);
        }
    }

    public void addMouseListener(final Action action) {
        if (this.mouseListener != null) {
            this.textField.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
        this.mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    action.actionPerformed(null);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        };
        this.textField.addMouseListener(this.mouseListener);
    }

    public void removeMouseListener() {
        if (this.mouseListener != null) {
            this.textField.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
    }
}

