/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Color;
import java.awt.Font;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.limewire.ui.swing.util.I18n;

public class HorizonalCheckBoxListPanel<K>
extends JPanel {
    private final Map<K, JCheckBox> optionsMap;

    public HorizonalCheckBoxListPanel(Collection<K> options) {
        this(options, null);
    }

    public HorizonalCheckBoxListPanel(Collection<K> options, Collection<K> selected) {
        this(options, selected, true);
    }

    public HorizonalCheckBoxListPanel(Collection<K> options, Collection<K> selected, boolean translate) {
        this.setLayout(new MigLayout("insets 0, gapx 5"));
        this.setOpaque(false);
        this.optionsMap = new HashMap<K, JCheckBox>();
        for (K key : options) {
            JCheckBox box = new JCheckBox(translate ? I18n.tr(key.toString()) : key.toString());
            box.setOpaque(false);
            box.setHorizontalTextPosition(4);
            box.setSelected(selected != null && selected.contains(key));
            this.add(box);
            this.optionsMap.put(key, box);
        }
    }

    public JCheckBox getCheckBox(K key) {
        return this.optionsMap.get(key);
    }

    public Collection<K> getSelected() {
        HashSet<K> selected = new HashSet<K>();
        for (K item : this.optionsMap.keySet()) {
            if (!this.optionsMap.get(item).isSelected()) continue;
            selected.add(item);
        }
        return selected;
    }

    public void setSelected(Collection<K> selectedKeys) {
        for (K key : this.optionsMap.keySet()) {
            if (selectedKeys.contains(key)) {
                this.optionsMap.get(key).setSelected(true);
                continue;
            }
            this.optionsMap.get(key).setSelected(false);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.optionsMap == null) {
            return;
        }
        for (JCheckBox checkBox : this.optionsMap.values()) {
            checkBox.setEnabled(enabled);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.optionsMap == null) {
            return;
        }
        for (JCheckBox checkBox : this.optionsMap.values()) {
            checkBox.setFont(font);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.optionsMap == null) {
            return;
        }
        for (JCheckBox checkBox : this.optionsMap.values()) {
            checkBox.setForeground(fg);
        }
    }
}

