/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.limewire.core.api.FilePropertyKey;

public class FilteredDocument
extends PlainDocument {
    private boolean acceptsNumeric = true;
    private boolean acceptsAlphabetic = true;
    private boolean acceptsNonAlphanumeric = true;
    private int maxChars = Integer.MAX_VALUE;
    private int minBound = Integer.MIN_VALUE;
    private int maxBound = Integer.MAX_VALUE;

    public static void configure(JTextField textField, FilePropertyKey key) {
        if (key != null && FilePropertyKey.isLong(key)) {
            FilteredDocument document = new FilteredDocument();
            document.setAcceptsAlphabetic(false);
            document.setAcceptsNumeric(true);
            document.setAcceptsNonAlphanumeric(false);
            switch (key) {
                case YEAR: 
                case BITRATE: {
                    document.setMaxChars(4);
                }
            }
            textField.setDocument(document);
        }
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        block10: {
            boolean accept = true;
            if (this.getLength() + str.length() > this.maxChars) {
                return;
            }
            if (!(this.acceptsAlphabetic && this.acceptsNumeric && this.acceptsNonAlphanumeric)) {
                for (byte c : str.getBytes()) {
                    boolean isAlphabetic = c >= 97 && c <= 122 || c >= 65 && c <= 90;
                    boolean isNumeric = c >= 48 && c <= 57;
                    accept &= this.acceptsAlphabetic && isAlphabetic || this.acceptsNumeric && isNumeric || this.acceptsNonAlphanumeric && !isAlphabetic && !isNumeric;
                }
                if (!accept) {
                    return;
                }
            }
            if (this.minBound != Integer.MIN_VALUE || this.maxBound != Integer.MAX_VALUE) {
                String currentText = this.getText(0, this.getLength());
                String joinedString = currentText.substring(0, offset) + str + currentText.substring(offset);
                if (!"-".equals(joinedString)) {
                    try {
                        int value = Integer.parseInt(joinedString);
                        if (value < this.minBound || value > this.maxBound) {
                            return;
                        }
                        break block10;
                    }
                    catch (NumberFormatException e) {
                        return;
                    }
                }
                if (this.minBound > -1 && this.maxBound > -1) {
                    return;
                }
            }
        }
        super.insertString(offset, str, a);
    }

    public void setAcceptsNumeric(boolean accepts) {
        this.acceptsNumeric = accepts;
    }

    public void setAcceptsAlphabetic(boolean accepts) {
        this.acceptsAlphabetic = accepts;
    }

    public void setAcceptsNonAlphanumeric(boolean accepts) {
        this.acceptsNonAlphanumeric = accepts;
    }

    public void setMaxChars(int max) {
        this.maxChars = max;
    }

    public void setMinBound(int min) {
        if (min > 1) {
            throw new IllegalArgumentException("Using a minimum bound that is more than 1 would make things impossible to use.");
        }
        this.minBound = min;
    }

    public void setMaxBound(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Using a maximum bound that is less than -1 would make things impossible to use.");
        }
        this.maxBound = max;
    }
}

