/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.browser;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIUtils;
import org.limewire.ui.swing.browser.UriAction;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaRuntimeException;
import org.mozilla.dom.NodeFactory;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.Mozilla;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class LimeDomListener
implements nsIDOMEventListener {
    private static final Log LOG = LogFactory.getLog(LimeDomListener.class);
    private final Map<String, UriAction> targetActions = new ConcurrentHashMap<String, UriAction>();
    private final Map<String, UriAction> protocolActions = new ConcurrentHashMap<String, UriAction>();

    public void addTargetedUrlAction(String target, UriAction action) {
        this.targetActions.put(target, action);
    }

    void addProtocolHandlerAction(String protocol, UriAction action) {
        this.protocolActions.put(protocol, action);
    }

    @Override
    public void handleEvent(nsIDOMEvent event) {
        assert (MozillaExecutor.isMozillaThread());
        try {
            UriAction.TargetedUri targetedUri = this.getTargetedUri(event);
            if (targetedUri != null) {
                UriAction action;
                String protocol = targetedUri.getProtocol();
                if (protocol != null && (action = this.protocolActions.get(protocol)) != null && action.uriClicked(targetedUri)) {
                    event.preventDefault();
                    return;
                }
                String target = targetedUri.getTarget();
                UriAction action2 = this.targetActions.get(target);
                if (action2 != null && action2.uriClicked(targetedUri)) {
                    event.preventDefault();
                    return;
                }
            }
        }
        catch (MozillaRuntimeException e) {
            LOG.error("MozillaRuntimeException", e);
        }
    }

    private UriAction.TargetedUri getTargetedUri(nsIDOMEvent event) {
        UriAction.TargetedUri targetedUrl = null;
        Node node = NodeFactory.getNodeInstance(event.getTarget());
        if ("click".equals(event.getType())) {
            if (!"html".equalsIgnoreCase(node.getNodeName()) && (targetedUrl = this.getTargetedUri(node)) == null) {
                targetedUrl = this.getTargetedUri(node.getParentNode());
            }
        } else if ("submit".equals(event.getType())) {
            targetedUrl = this.getTargetedFormAction(node);
            if ("magnet".equals(targetedUrl.getProtocol())) {
                return targetedUrl;
            }
            return null;
        }
        return targetedUrl;
    }

    private UriAction.TargetedUri getTargetedFormAction(Node node) {
        if (node != null) {
            if ("form".equalsIgnoreCase(node.getNodeName())) {
                String target;
                NamedNodeMap map = node.getAttributes();
                Node actionNode = map.getNamedItem("action");
                Node targetNode = map.getNamedItem("target");
                String action = actionNode != null ? actionNode.getNodeValue() : null;
                String string = target = targetNode != null && targetNode.getNodeValue() != null ? targetNode.getNodeValue() : "";
                if (action != null) {
                    return new UriAction.TargetedUri(target, action);
                }
            } else {
                return this.getTargetedFormAction(node.getParentNode());
            }
        }
        return null;
    }

    private UriAction.TargetedUri getTargetedUri(Node node) {
        Node hrefNode;
        NamedNodeMap map;
        if (node != null && (map = node.getAttributes()) != null && (hrefNode = map.getNamedItem("href")) != null) {
            String target = "";
            URI absoluteURI = null;
            try {
                absoluteURI = new URI(this.encode(hrefNode.getNodeValue()));
                if (!absoluteURI.isAbsolute() && node.getBaseURI() != null) {
                    URI baseUri = new URI(this.encode(node.getBaseURI()));
                    URI relativeURI = new URI(this.encode(hrefNode.getNodeValue()));
                    absoluteURI = URIUtils.resolve(baseUri, relativeURI);
                }
            }
            catch (URISyntaxException e) {
                absoluteURI = null;
            }
            if (absoluteURI == null || !absoluteURI.isAbsolute()) {
                return null;
            }
            Node targetNode = map.getNamedItem("target");
            if (targetNode != null) {
                target = targetNode.getNodeValue();
            }
            return new UriAction.TargetedUri(target, absoluteURI.toASCIIString());
        }
        return null;
    }

    public String encode(String uri) {
        if (uri == null) {
            return null;
        }
        return uri.replaceAll(" ", "%20");
    }

    @Override
    public nsISupports queryInterface(String uuid) {
        return Mozilla.queryInterface(this, uuid);
    }
}

