/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.animate;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.ui.swing.animate.Animator;
import org.limewire.ui.swing.animate.AnimatorEvent;

abstract class AbstractAnimator<T>
implements Animator<T> {
    private final Timer timer;
    private int stepNumber = 0;
    private final int totalNumberOfSteps;
    private final EventListenerList<AnimatorEvent<T>> eventListenerList;
    private final T component;
    private static final int STEP_TIME = 15;

    public AbstractAnimator(T component, int totalTime) {
        this.component = component;
        this.totalNumberOfSteps = (int)Math.ceil((double)totalTime / 15.0);
        this.eventListenerList = new EventListenerList();
        this.timer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ++AbstractAnimator.this.stepNumber;
                AbstractAnimator.this.eventListenerList.broadcast(new AnimatorEvent(AbstractAnimator.this, AnimatorEvent.Type.STEP));
                if (AbstractAnimator.this.stepNumber == AbstractAnimator.this.totalNumberOfSteps) {
                    AbstractAnimator.this.stop();
                }
            }
        });
        this.timer.setDelay(15);
    }

    @Override
    public void setInitialDelay(int initialDelay) {
        this.timer.setInitialDelay(initialDelay);
    }

    @Override
    public void start() {
        this.timer.start();
        this.eventListenerList.broadcast(new AnimatorEvent(this, AnimatorEvent.Type.STARTED));
    }

    @Override
    public void stop() {
        this.eventListenerList.broadcast(new AnimatorEvent(this, AnimatorEvent.Type.STOPPED));
        this.timer.stop();
    }

    @Override
    public int getTotalNumberOfSteps() {
        return this.totalNumberOfSteps;
    }

    @Override
    public void addListener(EventListener<AnimatorEvent<T>> listener) {
        this.eventListenerList.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<AnimatorEvent<T>> listener) {
        return this.eventListenerList.removeListener(listener);
    }

    @Override
    public int getCurrentStepNumber() {
        return this.stepNumber;
    }

    @Override
    public T getComponent() {
        return this.component;
    }
}

