/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.advanced.connection;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.impl.swing.SwingThreadProxyEventList;
import ca.odell.glazedlists.swing.DefaultEventListModel;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.monitor.IncomingSearchManager;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.search.DefaultSearchInfo;
import org.limewire.ui.swing.search.SearchHandler;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class IncomingSearchPanel
extends JPanel
implements Disposable {
    private IncomingSearchManager incomingManager;
    private SwingThreadProxyEventList<String> swingThreadList;
    private SearchHandler searchHandler;
    private JLabel incomingLabel = new JLabel();
    private JScrollPane scrollPane = new JScrollPane();
    private JList incomingList = new JList();

    @Inject
    public IncomingSearchPanel(IncomingSearchManager incomingManager, SearchHandler searchHandler) {
        this.incomingManager = incomingManager;
        this.searchHandler = searchHandler;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.incomingLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        this.incomingLabel.setText(I18n.tr("Incoming Searches - people on the P2P Network are now searching for..."));
        this.scrollPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.incomingList.setPrototypeCellValue("                                      ");
        this.incomingList.setFixedCellHeight(16);
        this.incomingList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() >= 2 && (index = IncomingSearchPanel.this.incomingList.locationToIndex(e.getPoint())) != -1) {
                    Object text = IncomingSearchPanel.this.incomingList.getModel().getElementAt(index);
                    IncomingSearchPanel.this.doSearch(String.valueOf(text));
                }
            }
        });
        this.add((Component)this.incomingLabel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.setViewportView(this.incomingList);
    }

    public void initData() {
        if (!(this.incomingList.getModel() instanceof DefaultEventListModel)) {
            EventList<String> incomingSearchList = this.incomingManager.getIncomingSearchList();
            this.swingThreadList = GlazedListsFactory.swingThreadProxyEventList(incomingSearchList);
            this.incomingList.setModel(new DefaultEventListModel<String>(this.swingThreadList));
        }
    }

    @Override
    public void dispose() {
        ListModel listModel = this.incomingList.getModel();
        if (listModel instanceof DefaultEventListModel) {
            ((DefaultEventListModel)listModel).dispose();
        }
        if (this.swingThreadList != null) {
            this.swingThreadList.dispose();
            this.swingThreadList = null;
        }
        this.incomingList.setModel(new DefaultListModel());
    }

    private void doSearch(String text) {
        SearchCategory defaultCategory = SearchCategory.forId(SwingUiSettings.DEFAULT_SEARCH_CATEGORY_ID.getValue());
        this.searchHandler.doSearch(DefaultSearchInfo.createKeywordSearch(text, defaultCategory));
        GuiUtils.getMainFrame().toFront();
    }
}

