/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.action;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import org.limewire.core.api.URN;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.NativeLaunchUtils;

public class BitziLookupAction
extends AbstractAction {
    private static final String BITZI_LOOKUP_URL = "http://bitzi.com/lookup/{0}?ref=limewire";
    private final PropertiableFile propertiableFile;

    public BitziLookupAction(PropertiableFile file) {
        super(I18n.tr("Lookup on Bitzi"));
        this.propertiableFile = file;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        URN urn = this.propertiableFile.getUrn();
        if (urn != null) {
            String urnStr = ((Object)urn).toString();
            int hashstart = 1 + urnStr.indexOf(":", 4);
            String lookupUrl = MessageFormat.format(BITZI_LOOKUP_URL, urnStr.substring(hashstart));
            NativeLaunchUtils.openURL(lookupUrl);
        }
    }
}

