/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.support;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.limewire.core.api.support.LocalClientInfo;
import org.limewire.core.api.support.LocalClientInfoFactory;
import org.limewire.core.impl.support.LocalClientInfoImpl;
import org.limewire.ui.support.NoSessionInfo;
import org.limewire.ui.support.ServletAccessor;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.LimeJDialog;
import org.limewire.ui.swing.components.MultiLineLabel;

public final class FatalBugManager {
    @Inject
    private static volatile LocalClientInfoFactory localClientInfoFactory;

    private FatalBugManager() {
    }

    public static void handleFatalBug(Throwable bug) {
        if (bug instanceof ThreadDeath) {
            throw (ThreadDeath)bug;
        }
        bug.printStackTrace();
        final LocalClientInfo info = localClientInfoFactory != null ? localClientInfoFactory.createLocalClientInfo(bug, Thread.currentThread().getName(), null, true) : new LocalClientInfoImpl(bug, Thread.currentThread().getName(), null, true, new NoSessionInfo());
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        FatalBugManager.reviewBug(info);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            FatalBugManager.reviewBug(info);
        }
    }

    public static void reviewBug(final LocalClientInfo info) {
        final LimeJDialog dialog = new LimeJDialog();
        dialog.setSize(new Dimension(300, 100));
        dialog.setTitle("LimeWire Couldn't Start :-(");
        dialog.setDefaultCloseOperation(2);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(1);
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new GridBagLayout());
        String msg = "Sorry, LimeWire ran into a problem while it was starting up. This is usually caused by a problem during installation. Try downloading and installing LimeWire again. If that doesn't fix it, visit www.limewire.com and click on 'Support'. You can also send the bug to us so we can try and fix it.";
        MultiLineLabel label = new MultiLineLabel(msg, 500);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        labelPanel.add((Component)label, constraints);
        final JPanel bugSpecificsPanel = new JPanel();
        bugSpecificsPanel.setLayout(new GridBagLayout());
        bugSpecificsPanel.setVisible(false);
        JTextArea showBug = new JTextArea(info.toBugReport());
        showBug.setColumns(50);
        showBug.setEditable(false);
        showBug.setCaretPosition(0);
        showBug.setLineWrap(true);
        showBug.setWrapStyleWord(true);
        JScrollPane showBugScroller = new JScrollPane(showBug);
        showBugScroller.setBorder(BorderFactory.createEtchedBorder());
        showBugScroller.setPreferredSize(new Dimension(500, 200));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        bugSpecificsPanel.add((Component)showBugScroller, constraints);
        String defaultDesc = "Want to help? Write in some extra info to help us find what's causing LimeWire to crash.";
        final JTextArea userCommentsTextArea = new JTextArea("Want to help? Write in some extra info to help us find what's causing LimeWire to crash.");
        userCommentsTextArea.setLineWrap(true);
        userCommentsTextArea.setWrapStyleWord(true);
        userCommentsTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (userCommentsTextArea.getText().equals("Want to help? Write in some extra info to help us find what's causing LimeWire to crash.")) {
                    userCommentsTextArea.selectAll();
                }
            }
        });
        JScrollPane userCommentsScrollPane = new JScrollPane(userCommentsTextArea);
        userCommentsScrollPane.setBorder(BorderFactory.createEtchedBorder());
        userCommentsScrollPane.setPreferredSize(new Dimension(500, 60));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(10, 0, 0, 0);
        bugSpecificsPanel.add((Component)userCommentsScrollPane, constraints);
        final HyperlinkButton showHideBugLink = new HyperlinkButton("Show Bug");
        showHideBugLink.addActionListener(new AbstractAction(){
            boolean panelVisible = false;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.panelVisible) {
                    bugSpecificsPanel.setVisible(false);
                    showHideBugLink.setText("Show Bug");
                    dialog.pack();
                } else {
                    bugSpecificsPanel.setVisible(true);
                    showHideBugLink.setText("Hide Bug");
                }
                dialog.pack();
                this.panelVisible = !this.panelVisible;
            }
        });
        final JButton sendButton = new JButton("Send Bug");
        sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String userComments = userCommentsTextArea.getText();
                if (!userComments.equals("Want to help? Write in some extra info to help us find what's causing LimeWire to crash.")) {
                    info.addUserComments(userComments);
                }
                sendButton.setEnabled(false);
                sendButton.setText("Sending...");
                new Thread("Fatal Bug Sending Thread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            FatalBugManager.sendToServlet(info);
                        }
                        catch (Throwable throwable) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    dialog.dispose();
                                    System.exit(1);
                                }
                            });
                            throw throwable;
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }.start();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        mainPanel.add((Component)labelPanel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(10, 0, 0, 0);
        constraints.anchor = 21;
        mainPanel.add((Component)showHideBugLink, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(30, 0, 6, 0);
        mainPanel.add((Component)bugSpecificsPanel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        mainPanel.add((Component)sendButton, constraints);
        mainPanel.validate();
        dialog.getContentPane().add(mainPanel);
        dialog.pack();
        sendButton.requestFocusInWindow();
        dialog.setLocationRelativeTo(null);
        for (Window window : Window.getWindows()) {
            if (window == dialog) continue;
            window.setVisible(false);
            window.dispose();
        }
        dialog.setVisible(true);
        dialog.toFront();
    }

    private static void sendToServlet(LocalClientInfo info) {
        new ServletAccessor().getRemoteBugInfo(info);
    }
}

