/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.swarm.http;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.impl.nio.DefaultClientIOEventDispatch;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.entity.ConsumingNHttpEntityTemplate;
import org.apache.http.nio.protocol.AsyncNHttpClientHandler;
import org.apache.http.nio.protocol.NHttpRequestExecutionHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.nio.reactor.SessionRequestCallback;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.protocol.HttpContext;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.Range;
import org.limewire.http.reactor.LimeConnectingIOReactor;
import org.limewire.http.reactor.LimeConnectingIOReactorFactory;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.swarm.SwarmCoordinator;
import org.limewire.swarm.SwarmFile;
import org.limewire.swarm.SwarmSource;
import org.limewire.swarm.SwarmSourceDownloader;
import org.limewire.swarm.http.HttpSourceAttachment;
import org.limewire.swarm.http.SwarmAsyncNHttpClientHandlerBuilder;
import org.limewire.swarm.http.SwarmHttpSourceStatus;
import org.limewire.swarm.http.SwarmHttpUtils;
import org.limewire.swarm.http.SwarmStats;
import org.limewire.swarm.http.listener.ResponseContentListener;
import org.limewire.swarm.http.listener.SwarmHttpContentListener;
import org.limewire.util.Objects;

public class SwarmHttpSourceDownloader
implements SwarmSourceDownloader,
NHttpRequestExecutionHandler {
    private static final Log LOG = LogFactory.getLog(SwarmHttpSourceDownloader.class);
    private final LimeConnectingIOReactor ioReactor;
    private final IOEventDispatch eventDispatch;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final SwarmCoordinator swarmCoordinator;
    private final SwarmStats stats;

    public SwarmHttpSourceDownloader(LimeConnectingIOReactorFactory limeConnectingIOReactorFactory, SwarmCoordinator swarmCoordinator, String userAgent) {
        this.swarmCoordinator = Objects.nonNull(swarmCoordinator, "swarmCoordinator");
        this.stats = new SwarmStats();
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.timeout", 5000).setIntParameter("http.connection.timeout", 2000).setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setParameter("http.useragent", userAgent);
        this.ioReactor = limeConnectingIOReactorFactory.createIOReactor(params);
        SwarmAsyncNHttpClientHandlerBuilder builder = new SwarmAsyncNHttpClientHandlerBuilder(params, this);
        AsyncNHttpClientHandler clientHandler = builder.get();
        this.eventDispatch = new DefaultClientIOEventDispatch(clientHandler, params);
    }

    @Override
    public void addSource(SwarmSource source) {
        LOG.tracef("Adding source: {0}", (Object)source);
        this.stats.incrementNumberOfSources();
        SwarmHttpSessionRequestCallback sessionRequestCallback = new SwarmHttpSessionRequestCallback(source);
        LOG.tracef("Connecting source to ioReactor: {0}", (Object)source);
        this.ioReactor.connect(source.getAddress(), null, new HttpSourceAttachment(source), sessionRequestCallback);
    }

    @Override
    public boolean isComplete() {
        return this.swarmCoordinator.isComplete();
    }

    @Override
    public void shutdown() throws IOException {
        LOG.tracef("Shutting down: {0}", (Object)this);
        this.started.set(false);
        LOG.tracef("Shutting ioReactor: {0}", (Object)this.ioReactor);
        this.ioReactor.shutdown();
    }

    @Override
    public void start() throws IOException {
        LOG.tracef("Starting: {0}", (Object)this);
        this.started.set(true);
        this.ioReactor.execute(this.eventDispatch);
    }

    @Override
    public boolean isActive() {
        return this.started.get();
    }

    @Override
    public float getMeasuredBandwidth(boolean downstream) {
        return this.ioReactor.getMeasuredBandwidth(downstream);
    }

    @Override
    public void initalizeContext(HttpContext context, Object attachment) {
        LOG.tracef("initalizeContext: {0}", (Object)this);
        HttpSourceAttachment info = (HttpSourceAttachment)attachment;
        context.setAttribute("swarm.http.source", info.getSource());
    }

    @Override
    public void finalizeContext(HttpContext context) {
        LOG.tracef("finalizeContext: {0}", (Object)this);
        SwarmSource source = this.getSwarmSource(context);
        source.connectionClosed(this);
        this.closeContentListener(context);
    }

    @Override
    public void handleResponse(HttpResponse response, HttpContext context) throws IOException {
        LOG.tracef("handleResponse: {0}", (Object)this);
        this.stats.incrementNumberOfResponses();
        if (this.isActive()) {
            int code;
            SwarmSource source = this.getSwarmSource(context);
            source.responseProcessed(this, new SwarmHttpSourceStatus(response.getStatusLine()));
            if (LOG.isTraceEnabled()) {
                LOG.trace(SwarmHttpUtils.logReponse("response", response));
            }
            if ((code = response.getStatusLine().getStatusCode()) < 200 || code >= 300) {
                this.closeConnection(context);
            }
        }
    }

    @Override
    public ConsumingNHttpEntity responseEntity(HttpResponse response, HttpContext context) throws IOException {
        LOG.trace(this);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Handling response: " + response.getStatusLine() + ", headers: " + Arrays.asList(response.getAllHeaders()));
        }
        ResponseContentListener listener = (ResponseContentListener)context.getAttribute("swarm.basic.listener");
        int code = response.getStatusLine().getStatusCode();
        if (code >= 200 && code < 300) {
            listener.initialize(response);
            context.setAttribute("swarm.basic.listener", null);
            return new ConsumingNHttpEntityTemplate(response.getEntity(), listener);
        }
        listener.finished();
        context.setAttribute("swarm.basic.listener", null);
        return null;
    }

    @Override
    public HttpRequest submitRequest(HttpContext context) {
        LOG.trace(this);
        if (this.isActive()) {
            SwarmSource swarmSource = this.getSwarmSource(context);
            HttpRequest request = null;
            if (swarmSource.isFinished() || this.isComplete()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("swarmSource.isFinished(): " + swarmSource.isFinished() + " isComplete(): " + this.isComplete());
                }
            } else {
                request = this.buildRequest(context);
                if (LOG.isTraceEnabled()) {
                    LOG.trace(SwarmHttpUtils.logRequest("submitRequest", request));
                }
            }
            if (request == null) {
                LOG.debugf("No more data to request for this swarm source: {0} finishing all listeners then closing connection from context.", (Object)swarmSource);
                this.closeConnection(context);
            } else {
                this.stats.incrementNumberOfRequests();
            }
            return request;
        }
        LOG.warn("submitRequest called while not active!");
        this.closeConnection(context);
        return null;
    }

    private SwarmSource getSwarmSource(HttpContext context) {
        SwarmSource swarmSource = (SwarmSource)context.getAttribute("swarm.http.source");
        return swarmSource;
    }

    private HttpRequest buildRequest(HttpContext context) {
        BasicHttpRequest request = null;
        SwarmSource source = this.getSwarmSource(context);
        RequestParameters requestParameters = this.buildRequestParameters(source);
        if (requestParameters != null) {
            SwarmFile swarmFile = requestParameters.getSwarmFile();
            Range leaseRange = requestParameters.getLeaseRange();
            Range downloadRange = requestParameters.getDownloadRange();
            this.stats.incrementNumberOfBytesRequested(downloadRange.getLength());
            context.setAttribute("swarm.basic.listener", new SwarmHttpContentListener(this.swarmCoordinator, swarmFile, leaseRange));
            request = new BasicHttpRequest("GET", requestParameters.getPath());
            request.addHeader(new BasicHeader("Range", "bytes=" + requestParameters.getLow() + "-" + requestParameters.getHigh()));
        }
        return request;
    }

    private void closeContentListener(HttpContext context) {
        ResponseContentListener contentListener;
        if (LOG.isTraceEnabled()) {
            LOG.trace("closing content listener: " + this, new Exception("debugging stack trace"));
        }
        if ((contentListener = (ResponseContentListener)context.getAttribute("swarm.basic.listener")) != null) {
            contentListener.finished();
            context.setAttribute("swarm.basic.listener", null);
        }
    }

    private void closeConnection(HttpContext context) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("closing connection: " + this, new Exception("debugging stack trace"));
        }
        this.closeContentListener(context);
        this.closeSwarmSource(context);
        SwarmHttpUtils.closeConnectionFromContext(context);
    }

    private void closeSwarmSource(HttpContext context) {
        SwarmSource swarmSource;
        if (LOG.isTraceEnabled()) {
            LOG.trace("closing swarmSource: " + this, new Exception("debugging stack trace"));
        }
        if ((swarmSource = this.getSwarmSource(context)) != null) {
            swarmSource.finished(this);
        }
    }

    private RequestParameters buildRequestParameters(SwarmSource source) {
        IntervalSet availableRanges = source.getAvailableRanges();
        Range leaseRange = this.swarmCoordinator.leasePortion(availableRanges);
        if (leaseRange == null) {
            LOG.debug("No range available to lease.");
            return null;
        }
        SwarmFile swarmFile = this.swarmCoordinator.getSwarmFile(leaseRange);
        long fileEndByte = swarmFile.getEndBytePosition();
        if (leaseRange.getHigh() > fileEndByte) {
            Range oldRange = leaseRange;
            leaseRange = Range.createRange(leaseRange.getLow(), fileEndByte);
            leaseRange = this.swarmCoordinator.renewLease(oldRange, leaseRange);
        }
        long downloadRangeStart = leaseRange.getLow() - swarmFile.getStartBytePosition();
        long downloadRangeEnd = leaseRange.getHigh() - swarmFile.getStartBytePosition();
        Range downloadRange = Range.createRange(downloadRangeStart, downloadRangeEnd);
        RequestParameters requestParameters = new RequestParameters(swarmFile, source.getPath(), leaseRange, downloadRange);
        return requestParameters;
    }

    private class SwarmHttpSessionRequestCallback
    implements SessionRequestCallback {
        private final SwarmSource source;

        public SwarmHttpSessionRequestCallback(SwarmSource source) {
            this.source = source;
        }

        @Override
        public void cancelled(SessionRequest request) {
            this.source.connectFailed(SwarmHttpSourceDownloader.this);
        }

        @Override
        public void completed(SessionRequest request) {
            this.source.connected(SwarmHttpSourceDownloader.this);
        }

        @Override
        public void failed(SessionRequest request) {
            this.source.connectFailed(SwarmHttpSourceDownloader.this);
        }

        @Override
        public void timeout(SessionRequest request) {
            this.source.connectFailed(SwarmHttpSourceDownloader.this);
        }
    }

    private static class RequestParameters {
        private final SwarmFile swarmFile;
        private final String path;
        private final Range leaseRange;
        private final Range downloadRange;

        public RequestParameters(SwarmFile swarmFile, String path, Range leaseRange, Range downloadRange) {
            this.swarmFile = Objects.nonNull(swarmFile, "swarmFile");
            this.path = Objects.nonNull(path, "path");
            this.leaseRange = Objects.nonNull(leaseRange, "leaseRange");
            this.downloadRange = Objects.nonNull(downloadRange, "downloadRange");
        }

        public String getPath() {
            String path = this.path;
            if (path.length() > 0 && path.charAt(path.length() - 1) == '/') {
                path = path + this.swarmFile.getPath();
            }
            return path;
        }

        public long getLow() {
            return this.downloadRange.getLow();
        }

        public long getHigh() {
            return this.downloadRange.getHigh();
        }

        public SwarmFile getSwarmFile() {
            return this.swarmFile;
        }

        public Range getLeaseRange() {
            return this.leaseRange;
        }

        public Range getDownloadRange() {
            return this.downloadRange;
        }
    }
}

