/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.service;

import org.limewire.service.MessageCallback;
import org.limewire.service.Switch;

public class MessageService {
    private static volatile MessageCallback _callback = new ShellMessageService();

    private MessageService() {
    }

    public static void setCallback(MessageCallback callback) {
        _callback = callback;
    }

    public static MessageCallback getCallback() {
        return _callback;
    }

    public static void showError(String messageKey) {
        _callback.showError(messageKey);
    }

    public static void showError(String messageKey, Switch ignore) {
        _callback.showError(messageKey, ignore);
    }

    public static void showMessage(String messageKey) {
        _callback.showMessage(messageKey);
    }

    public static void showMessage(String messageKey, Switch ignore) {
        _callback.showMessage(messageKey, ignore);
    }

    public static void showFormattedMessage(String messageKey, Object ... args) {
        _callback.showFormattedMessage(messageKey, args);
    }

    public static void showFormattedMessage(String messageKey, Switch ignore, Object ... args) {
        _callback.showFormattedMessage(messageKey, ignore, args);
    }

    public static void showFormattedError(String errorKey, Object ... args) {
        _callback.showFormattedError(errorKey, args);
    }

    public static void showFormattedError(String errorKey, Switch ignore, Object ... args) {
        _callback.showFormattedError(errorKey, ignore, args);
    }

    private static final class ShellMessageService
    implements MessageCallback {
        private ShellMessageService() {
        }

        @Override
        public void showError(String messageKey) {
            System.out.println("error key: " + messageKey);
        }

        @Override
        public void showError(String messageKey, Switch ignore) {
            this.showError(messageKey);
        }

        @Override
        public void showMessage(String messageKey) {
            System.out.println("message key: " + messageKey);
        }

        @Override
        public void showMessage(String messageKey, Switch ignore) {
            this.showMessage(messageKey);
        }

        @Override
        public void showFormattedMessage(String messageKey, Object ... args) {
            StringBuilder sb = new StringBuilder("message key: " + messageKey + " ");
            for (int i = 0; i < args.length; ++i) {
                sb.append("arg[").append(i).append("]: ").append(args[i]);
                if (i >= args.length - 1) continue;
                sb.append(", ");
            }
            System.out.println(sb);
        }

        @Override
        public void showFormattedMessage(String messageKey, Switch ignore, Object ... args) {
            this.showFormattedMessage(messageKey, args);
        }

        @Override
        public void showFormattedError(String errorKey, Object ... args) {
            StringBuilder sb = new StringBuilder("error key: " + errorKey + " ");
            for (int i = 0; i < args.length; ++i) {
                sb.append("arg[").append(i).append("]: ").append(args[i]);
                if (i >= args.length - 1) continue;
                sb.append(", ");
            }
            System.out.println(sb);
        }

        @Override
        public void showFormattedError(String errorKey, Switch ignore, Object ... args) {
            this.showFormattedError(errorKey, args);
        }
    }
}

