/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.security.SecureMessage;
import org.limewire.security.SecureMessageCallback;

public abstract class Verifier
implements Runnable {
    private static final Log LOG = LogFactory.getLog(Verifier.class);
    private SecureMessage message;
    private SecureMessageCallback callback;

    public Verifier(SecureMessage message, SecureMessageCallback callback) {
        this.message = message;
        this.callback = callback;
    }

    public abstract PublicKey getPublicKey();

    public abstract String getAlgorithm();

    public SecureMessage getSecureMessage() {
        return this.message;
    }

    public SecureMessageCallback getSecureMessageCallback() {
        return this.callback;
    }

    @Override
    public void run() {
        SecureMessage message = this.getSecureMessage();
        SecureMessageCallback callback = this.getSecureMessageCallback();
        PublicKey pubKey = this.getPublicKey();
        String algorithm = this.getAlgorithm();
        if (pubKey == null) {
            LOG.warn("Cannot verify message without a public key.");
            message.setSecureStatus(SecureMessage.Status.INSECURE);
            callback.handleSecureMessage(message, false);
            return;
        }
        byte[] signature = message.getSecureSignature();
        if (signature == null) {
            LOG.warn("Cannot verify message without a signature.");
            message.setSecureStatus(SecureMessage.Status.INSECURE);
            callback.handleSecureMessage(message, false);
            return;
        }
        try {
            Signature verifier = Signature.getInstance(algorithm);
            verifier.initVerify(pubKey);
            message.updateSignatureWithSecuredBytes(verifier);
            if (verifier.verify(signature)) {
                message.setSecureStatus(SecureMessage.Status.SECURE);
                callback.handleSecureMessage(message, true);
                return;
            }
        }
        catch (NoSuchAlgorithmException nsax) {
            LOG.error("No alg.", nsax);
        }
        catch (InvalidKeyException ikx) {
            LOG.error("Invalid key", ikx);
        }
        catch (SignatureException sx) {
            LOG.error("Bad sig", sx);
        }
        catch (ClassCastException ccx) {
            LOG.error("bad cast", ccx);
        }
        message.setSecureStatus(SecureMessage.Status.FAILED);
        callback.handleSecureMessage(message, false);
    }
}

