/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketAddress;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.MACCalculatorRepositoryManager;

public interface SecurityToken {
    public byte[] getBytes();

    public void write(OutputStream var1) throws IOException;

    public boolean isFor(TokenData var1);

    @Singleton
    public static class AddressSecurityTokenProvider
    implements TokenProvider {
        private final MACCalculatorRepositoryManager manager;

        @Inject
        public AddressSecurityTokenProvider(MACCalculatorRepositoryManager manager) {
            this.manager = manager;
        }

        @Override
        public SecurityToken getSecurityToken(SocketAddress addr) {
            return new AddressSecurityToken(addr, this.manager);
        }

        @Override
        public TokenData getTokenData(SocketAddress src) {
            return new AddressSecurityToken.AddressTokenData(src);
        }
    }

    public static interface TokenData {
        public byte[] getData();
    }

    public static interface TokenProvider {
        public SecurityToken getSecurityToken(SocketAddress var1);

        public TokenData getTokenData(SocketAddress var1);
    }
}

