/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net.collection;

import java.net.InetAddress;
import java.util.BitSet;
import org.limewire.io.NetworkUtils;

public class MaskedIPSet
extends BitSet {
    private static final long serialVersionUID = 8152241226787435317L;
    private static final int IPV4_SIZE = 32;
    private final int mask;

    public MaskedIPSet(int mask) {
        super(MaskedIPSet.assertMask(mask));
        this.mask = 32 - mask;
    }

    private static int assertMask(int size) {
        assert (size <= 32);
        return 1 << size;
    }

    public void set(InetAddress addr) {
        this.set(this.ipV4ToInt(addr));
    }

    public void setInt(int ip) {
        this.set(this.intToMasked(ip));
    }

    public boolean get(InetAddress addr) {
        return this.get(this.ipV4ToInt(addr));
    }

    public boolean getInt(int ip) {
        return this.get(this.intToMasked(ip));
    }

    public synchronized boolean getAndSet(InetAddress addr) {
        int index = this.ipV4ToInt(addr);
        boolean ret = this.get(index);
        this.set(index);
        return ret;
    }

    private int intToMasked(int ip) {
        int ret = (ip & -1 << this.mask) >>> this.mask;
        assert (ret < 1 << 32 - this.mask);
        return ret;
    }

    private int ipV4ToInt(InetAddress addr) {
        return this.intToMasked(NetworkUtils.getMaskedIP(addr, -1));
    }
}

