/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import com.google.inject.Inject;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Asynchronous;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.net.FirewallService;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;

@EagerSingleton
public class FirewallServiceImpl
implements FirewallService,
Service {
    public static final File LIMEWIRE_EXE_FILE = new File("LimeWire.exe").getAbsoluteFile();
    private static String name = "LimeWire";
    private AtomicBoolean needsCleanup = new AtomicBoolean(false);

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Firewall Manager");
    }

    @Override
    @Asynchronous(daemon=false)
    public void stop() {
        if (this.needsCleanup.get()) {
            if (!OSUtils.isWindows()) {
                return;
            }
            String path = SystemUtils.getRunningPath();
            if (!path.equalsIgnoreCase(LIMEWIRE_EXE_FILE.getPath())) {
                return;
            }
            if (SystemUtils.isProgramListedOnFirewall(path)) {
                SystemUtils.removeProgramFromFirewall(path);
            }
        }
    }

    @Override
    public boolean isProgrammaticallyConfigurable() {
        if (!(OSUtils.isWindows() && SystemUtils.isFirewallPresent() && SystemUtils.isFirewallEnabled())) {
            return false;
        }
        String path = SystemUtils.getRunningPath();
        return path.equalsIgnoreCase(LIMEWIRE_EXE_FILE.getPath());
    }

    @Override
    public boolean addToFirewall() {
        if (!OSUtils.isWindows()) {
            return false;
        }
        String path = SystemUtils.getRunningPath();
        if (path == null) {
            return false;
        }
        if (!path.equalsIgnoreCase(LIMEWIRE_EXE_FILE.getAbsolutePath())) {
            return false;
        }
        if (SystemUtils.isProgramListedOnFirewall(path)) {
            return true;
        }
        if (SystemUtils.addProgramToFirewall(path, name)) {
            this.needsCleanup.set(true);
            return true;
        }
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
    }
}

