/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import com.google.inject.Inject;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.CollectionUtils;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.io.SimpleNetworkInstanceUtils;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.ContactFactory;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.routing.impl.LocalContact;

public final class ContactUtils {
    private static final Log LOG = LogFactory.getLog(ContactUtils.class);
    @Inject
    private static volatile NetworkInstanceUtils networkInstanceUtils = new SimpleNetworkInstanceUtils();
    public static final Comparator<Contact> CONTACT_MRS_COMPARATOR = new Comparator<Contact>(){

        @Override
        public int compare(Contact a, Contact b) {
            return -ContactUtils.compareLong(a.getTimeStamp(), b.getTimeStamp());
        }
    };
    public static final Comparator<Contact> CONTACT_ALIVE_TO_FAILED_COMPARATOR = new Comparator<Contact>(){

        @Override
        public int compare(Contact a, Contact b) {
            if (!a.hasFailed() && !b.hasFailed()) {
                return CONTACT_MRS_COMPARATOR.compare(a, b);
            }
            if (a.hasFailed() && !b.hasFailed()) {
                return 1;
            }
            if (!a.hasFailed() && b.hasFailed()) {
                return -1;
            }
            return ContactUtils.compareLong(a.getLastFailedTime(), b.getLastFailedTime());
        }
    };

    public static void setNetworkInstanceUtils(NetworkInstanceUtils networkInstanceUtils) {
        ContactUtils.networkInstanceUtils = networkInstanceUtils;
    }

    private static int compareLong(long a, long b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    private ContactUtils() {
    }

    public static String toString(KUID nodeId, SocketAddress address) {
        if (nodeId != null) {
            if (address != null) {
                return nodeId + " (" + address + ")";
            }
            return nodeId.toString();
        }
        if (address != null) {
            return address.toString();
        }
        return "null";
    }

    public static boolean isLocalAddress(Contact node) {
        return NetworkUtils.isLocalAddress(node.getContactAddress());
    }

    public static boolean areLocalContacts(Contact existing, Contact node) {
        InetSocketAddress newAddress = (InetSocketAddress)node.getContactAddress();
        InetSocketAddress oldAddress = (InetSocketAddress)existing.getContactAddress();
        return NetworkUtils.isLocalAddress(newAddress) && NetworkUtils.isLocalAddress(oldAddress) && newAddress.getPort() == oldAddress.getPort();
    }

    public static boolean isValidSocketAddress(Contact node) {
        return NetworkUtils.isValidSocketAddress(node.getContactAddress());
    }

    public static boolean isPrivateAddress(InetAddress addr) {
        return networkInstanceUtils.isPrivateAddress(addr);
    }

    public static boolean isPrivateAddress(SocketAddress address) {
        return networkInstanceUtils.isPrivateAddress(address);
    }

    public static boolean isPrivateAddress(Contact node) {
        return ContactUtils.isPrivateAddress(node.getContactAddress());
    }

    public static boolean isIPv4Address(Contact node) {
        InetAddress addr = ((InetSocketAddress)node.getContactAddress()).getAddress();
        return addr instanceof Inet4Address;
    }

    public static boolean isIPv4CompatibleAddress(Contact node) {
        InetAddress addr = ((InetSocketAddress)node.getContactAddress()).getAddress();
        return addr instanceof Inet6Address && ((Inet6Address)addr).isIPv4CompatibleAddress();
    }

    public static int getClassC(Contact node) {
        InetAddress addr = ((InetSocketAddress)node.getContactAddress()).getAddress();
        return NetworkUtils.getClassC(addr);
    }

    public static boolean isPrivateIPv4CompatibleAddress(Contact node) {
        InetAddress addr = ((InetSocketAddress)node.getContactAddress()).getAddress();
        return NetworkUtils.isPrivateIPv4CompatibleAddress(addr);
    }

    public static boolean isSameNodeID(Contact node1, Contact node2) {
        return node1.getNodeID().equals(node2.getNodeID());
    }

    public static boolean isCollision(Context context, Contact node) {
        return context.isLocalNodeID(node.getNodeID()) && !context.isLocalContactAddress(node.getContactAddress());
    }

    public static boolean isLocalContact(Context context, Contact node) {
        if (context.isLocalNodeID(node.getNodeID())) {
            return true;
        }
        if (context.isLocalContactAddress(node.getContactAddress())) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(node + " has the same Contact addess as we do " + context.getLocalNode());
            }
            return true;
        }
        return false;
    }

    public static boolean isSameAddressSpace(Contact a, Contact b) {
        return NetworkUtils.isSameAddressSpace(a.getContactAddress(), b.getContactAddress());
    }

    public static Contact createCollisionPingSender(Contact localNode) {
        if (!(localNode instanceof LocalContact)) {
            throw new IllegalArgumentException("Contact must be an instance of LocalContact: " + localNode);
        }
        Vendor vendor = localNode.getVendor();
        Version version = localNode.getVersion();
        KUID nodeId = localNode.getNodeID().invert();
        SocketAddress addr = localNode.getContactAddress();
        Contact sender = ContactFactory.createLiveContact(addr, vendor, version, nodeId, addr, 0, 1);
        return sender;
    }

    public static boolean isCollisionPingSender(KUID localNodeId, Contact sender) {
        if (!sender.isFirewalled()) {
            return false;
        }
        KUID expectedSenderId = localNodeId.invert();
        return expectedSenderId.equals(sender.getNodeID());
    }

    public static <T extends Contact> Contact getMostRecentlySeen(Collection<T> nodes) {
        List<T> list = CollectionUtils.toList(nodes);
        assert (((Contact)list.get(0)).getTimeStamp() >= ((Contact)list.get(nodes.size() - 1)).getTimeStamp());
        return (Contact)list.get(0);
    }

    public static <T extends Contact> Contact getLeastRecentlySeen(Collection<T> nodes) {
        List<T> list = CollectionUtils.toList(nodes);
        assert (((Contact)list.get(nodes.size() - 1)).getTimeStamp() <= ((Contact)list.get(0)).getTimeStamp());
        return (Contact)list.get(nodes.size() - 1);
    }

    public static <T extends Contact> Collection<T> sort(Collection<T> nodes, int count) {
        return ContactUtils.sort(nodes).subList(0, Math.min(count, nodes.size()));
    }

    public static <T extends Contact> List<T> sort(Collection<T> nodes) {
        List<T> list = CollectionUtils.toList(nodes);
        Collections.sort(list, CONTACT_MRS_COMPARATOR);
        return list;
    }

    public static <T extends Contact> List<T> sortAliveToFailed(Collection<T> nodes) {
        List<T> list = CollectionUtils.toList(nodes);
        Collections.sort(list, CONTACT_ALIVE_TO_FAILED_COMPARATOR);
        return list;
    }
}

