/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing;

import java.io.Serializable;

public class Version
implements Serializable,
Comparable<Version> {
    private static final long serialVersionUID = -4652316695244961502L;
    private static final Version[] VERSIONS = new Version[10];
    public static final int LENGTH = 2;
    public static final Version ZERO = new Version(0);
    private final int version;

    private Version(int version) {
        this.version = version;
    }

    public int getMajor() {
        return this.version >> 8 & 0xFF;
    }

    public int getMinor() {
        return this.version & 0xFF;
    }

    public int shortValue() {
        return this.version;
    }

    public int hashCode() {
        return this.version;
    }

    @Override
    public int compareTo(Version o) {
        return this.version - o.version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        return this.version == ((Version)o).version;
    }

    public String toString() {
        return this.getMajor() + "." + this.getMinor();
    }

    public static synchronized Version valueOf(int version) {
        if ((version & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("Version is out of range (0x0000 - 0xFFFF): " + version);
        }
        int index = version % VERSIONS.length;
        Version vers = VERSIONS[index];
        if (vers == null || vers.version != version) {
            Version.VERSIONS[index] = vers = new Version(version);
        }
        return vers;
    }

    public static Version valueOf(int major, int minor) {
        return Version.valueOf(major << 8 | minor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            int index = this.version % VERSIONS.length;
            Version vers = VERSIONS[index];
            if (vers == null || vers.version != this.version) {
                Version.VERSIONS[index] = vers = this;
            }
            return vers;
        }
    }
}

